/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.transport.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.sockjs.transport.SockJsServiceConfig;
import org.springframework.web.socket.sockjs.transport.session.WebSocketServerSockJsSession;

public class SockJsWebSocketHandler
extends TextWebSocketHandler
implements SubProtocolCapable {
    private final SockJsServiceConfig sockJsServiceConfig;
    private final WebSocketServerSockJsSession sockJsSession;
    private final List<String> subProtocols;
    private final AtomicInteger sessionCount = new AtomicInteger();

    public SockJsWebSocketHandler(SockJsServiceConfig serviceConfig, WebSocketHandler webSocketHandler, WebSocketServerSockJsSession sockJsSession) {
        ArrayList<String> arrayList;
        Assert.notNull((Object)serviceConfig, "serviceConfig must not be null");
        Assert.notNull((Object)webSocketHandler, "webSocketHandler must not be null");
        Assert.notNull((Object)sockJsSession, "session must not be null");
        this.sockJsServiceConfig = serviceConfig;
        this.sockJsSession = sockJsSession;
        webSocketHandler = WebSocketHandlerDecorator.unwrap(webSocketHandler);
        if (webSocketHandler instanceof SubProtocolCapable) {
            SubProtocolCapable subProtocolCapable = (SubProtocolCapable)((Object)webSocketHandler);
            arrayList = new ArrayList<String>(subProtocolCapable.getSubProtocols());
        } else {
            arrayList = Collections.emptyList();
        }
        this.subProtocols = arrayList;
    }

    @Override
    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    protected SockJsServiceConfig getSockJsConfig() {
        return this.sockJsServiceConfig;
    }

    @Override
    public void afterConnectionEstablished(WebSocketSession wsSession) throws Exception {
        Assert.state(this.sessionCount.compareAndSet(0, 1), "Unexpected connection");
        this.sockJsSession.initializeDelegateSession(wsSession);
    }

    @Override
    public void handleTextMessage(WebSocketSession wsSession, TextMessage message2) throws Exception {
        this.sockJsSession.handleMessage(message2, wsSession);
    }

    @Override
    public void afterConnectionClosed(WebSocketSession wsSession, CloseStatus status) throws Exception {
        this.sockJsSession.delegateConnectionClosed(status);
    }

    @Override
    public void handleTransportError(WebSocketSession webSocketSession, Throwable exception) throws Exception {
        this.sockJsSession.delegateError(exception);
    }
}

