/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.web.socket.server.support.AbstractHandshakeHandler;

class HandshakeHandlerRuntimeHints
implements RuntimeHintsRegistrar {
    private static final boolean tomcatWsPresent;
    private static final boolean jettyWsPresent;
    private static final boolean undertowWsPresent;
    private static final boolean glassfishWsPresent;
    private static final boolean weblogicWsPresent;
    private static final boolean websphereWsPresent;

    HandshakeHandlerRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        ReflectionHints reflectionHints = hints.reflection();
        if (tomcatWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.TomcatRequestUpgradeStrategy");
        } else if (jettyWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy");
        } else if (undertowWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.UndertowRequestUpgradeStrategy");
        } else if (glassfishWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.GlassFishRequestUpgradeStrategy");
        } else if (weblogicWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.WebLogicRequestUpgradeStrategy");
        } else if (websphereWsPresent) {
            this.registerType(reflectionHints, "org.springframework.web.socket.server.standard.WebSphereRequestUpgradeStrategy");
        }
    }

    private void registerType(ReflectionHints reflectionHints, String className) {
        reflectionHints.registerType(TypeReference.of(className), (TypeHint.Builder builder) -> builder.withMembers(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS));
    }

    static {
        ClassLoader classLoader = AbstractHandshakeHandler.class.getClassLoader();
        tomcatWsPresent = ClassUtils.isPresent("org.apache.tomcat.websocket.server.WsHttpUpgradeHandler", classLoader);
        jettyWsPresent = ClassUtils.isPresent("org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServerContainer", classLoader);
        undertowWsPresent = ClassUtils.isPresent("io.undertow.websockets.jsr.ServerWebSocketContainer", classLoader);
        glassfishWsPresent = ClassUtils.isPresent("org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler", classLoader);
        weblogicWsPresent = ClassUtils.isPresent("weblogic.websocket.tyrus.TyrusServletWriter", classLoader);
        websphereWsPresent = ClassUtils.isPresent("com.ibm.websphere.wsoc.WsWsocServerContainer", classLoader);
    }
}

