/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.messaging;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.stomp.BufferingStompDecoder;
import org.springframework.messaging.simp.stomp.ConnectionHandlingStompSession;
import org.springframework.messaging.simp.stomp.SplittingStompEncoder;
import org.springframework.messaging.simp.stomp.StompClientSupport;
import org.springframework.messaging.simp.stomp.StompDecoder;
import org.springframework.messaging.simp.stomp.StompEncoder;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.messaging.tcp.TcpConnection;
import org.springframework.messaging.tcp.TcpConnectionHandler;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.handler.LoggingWebSocketHandlerDecorator;
import org.springframework.web.socket.sockjs.transport.SockJsSession;
import org.springframework.web.util.UriComponentsBuilder;

public class WebSocketStompClient
extends StompClientSupport
implements SmartLifecycle {
    private static final Log logger = LogFactory.getLog(WebSocketStompClient.class);
    private final WebSocketClient webSocketClient;
    private int inboundMessageSizeLimit = 65536;
    @Nullable
    private Integer outboundMessageSizeLimit;
    private boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private volatile boolean running;

    public WebSocketStompClient(WebSocketClient webSocketClient) {
        Assert.notNull((Object)webSocketClient, "WebSocketClient is required");
        this.webSocketClient = webSocketClient;
        this.setDefaultHeartbeat(new long[]{0L, 0L});
    }

    public WebSocketClient getWebSocketClient() {
        return this.webSocketClient;
    }

    @Override
    public void setTaskScheduler(@Nullable TaskScheduler taskScheduler) {
        if (!this.isDefaultHeartbeatEnabled()) {
            this.setDefaultHeartbeat(new long[]{10000L, 10000L});
        }
        super.setTaskScheduler(taskScheduler);
    }

    public void setInboundMessageSizeLimit(int inboundMessageSizeLimit) {
        this.inboundMessageSizeLimit = inboundMessageSizeLimit;
    }

    public int getInboundMessageSizeLimit() {
        return this.inboundMessageSizeLimit;
    }

    public void setOutboundMessageSizeLimit(Integer outboundMessageSizeLimit) {
        this.outboundMessageSizeLimit = outboundMessageSizeLimit;
    }

    @Nullable
    public Integer getOutboundMessageSizeLimit() {
        return this.outboundMessageSizeLimit;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public void start() {
        if (!this.isRunning()) {
            this.running = true;
            WebSocketClient webSocketClient = this.getWebSocketClient();
            if (webSocketClient instanceof Lifecycle) {
                Lifecycle lifecycle = (Lifecycle)((Object)webSocketClient);
                lifecycle.start();
            }
        }
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            WebSocketClient webSocketClient = this.getWebSocketClient();
            if (webSocketClient instanceof Lifecycle) {
                Lifecycle lifecycle = (Lifecycle)((Object)webSocketClient);
                lifecycle.stop();
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Deprecated(since="6.0", forRemoval=true)
    public ListenableFuture<StompSession> connect(String url, StompSessionHandler handler, Object ... uriVars) {
        return new CompletableToListenableFutureAdapter<StompSession>(this.connectAsync(url, handler, uriVars));
    }

    public CompletableFuture<StompSession> connectAsync(String url, StompSessionHandler handler, Object ... uriVars) {
        return this.connectAsync(url, null, handler, uriVars);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public ListenableFuture<StompSession> connect(String url, @Nullable WebSocketHttpHeaders handshakeHeaders, StompSessionHandler handler, Object ... uriVariables) {
        return new CompletableToListenableFutureAdapter<StompSession>(this.connectAsync(url, handshakeHeaders, null, handler, uriVariables));
    }

    public CompletableFuture<StompSession> connectAsync(String url, @Nullable WebSocketHttpHeaders handshakeHeaders, StompSessionHandler handler, Object ... uriVariables) {
        return this.connectAsync(url, handshakeHeaders, null, handler, uriVariables);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public ListenableFuture<StompSession> connect(String url, @Nullable WebSocketHttpHeaders handshakeHeaders, @Nullable StompHeaders connectHeaders, StompSessionHandler handler, Object ... uriVariables) {
        return new CompletableToListenableFutureAdapter<StompSession>(this.connectAsync(url, handshakeHeaders, connectHeaders, handler, uriVariables));
    }

    public CompletableFuture<StompSession> connectAsync(String url, @Nullable WebSocketHttpHeaders handshakeHeaders, @Nullable StompHeaders connectHeaders, StompSessionHandler handler, Object ... uriVariables) {
        Assert.notNull((Object)url, "'url' must not be null");
        URI uri = UriComponentsBuilder.fromUriString(url).buildAndExpand(uriVariables).encode().toUri();
        return this.connectAsync(uri, handshakeHeaders, connectHeaders, handler);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public ListenableFuture<StompSession> connect(URI url, @Nullable WebSocketHttpHeaders handshakeHeaders, @Nullable StompHeaders connectHeaders, StompSessionHandler sessionHandler) {
        return new CompletableToListenableFutureAdapter<StompSession>(this.connectAsync(url, handshakeHeaders, connectHeaders, sessionHandler));
    }

    public CompletableFuture<StompSession> connectAsync(URI url, @Nullable WebSocketHttpHeaders handshakeHeaders, @Nullable StompHeaders connectHeaders, StompSessionHandler sessionHandler) {
        Assert.notNull((Object)url, "'url' must not be null");
        ConnectionHandlingStompSession session = this.createSession(connectHeaders, sessionHandler);
        WebSocketTcpConnectionHandlerAdapter adapter = new WebSocketTcpConnectionHandlerAdapter(session);
        this.getWebSocketClient().execute((WebSocketHandler)new LoggingWebSocketHandlerDecorator(adapter), handshakeHeaders, url).whenComplete((BiConsumer)adapter);
        return session.getSession();
    }

    @Override
    protected StompHeaders processConnectHeaders(@Nullable StompHeaders connectHeaders) {
        if ((connectHeaders = super.processConnectHeaders(connectHeaders)).isHeartbeatEnabled()) {
            Assert.state(this.getTaskScheduler() != null, "TaskScheduler must be set if heartbeats are enabled");
        }
        return connectHeaders;
    }

    private class WebSocketTcpConnectionHandlerAdapter
    implements BiConsumer<WebSocketSession, Throwable>,
    WebSocketHandler,
    TcpConnection<byte[]> {
        private final TcpConnectionHandler<byte[]> stompSession;
        private final StompWebSocketMessageCodec codec;
        @Nullable
        private volatile WebSocketSession session;
        private volatile long lastReadTime;
        private volatile long lastWriteTime;
        @Nullable
        private ScheduledFuture<?> readInactivityFuture;
        @Nullable
        private ScheduledFuture<?> writeInactivityFuture;

        public WebSocketTcpConnectionHandlerAdapter(TcpConnectionHandler<byte[]> stompSession) {
            this.codec = new StompWebSocketMessageCodec(WebSocketStompClient.this.getInboundMessageSizeLimit(), WebSocketStompClient.this.getOutboundMessageSizeLimit());
            this.lastReadTime = -1L;
            this.lastWriteTime = -1L;
            Assert.notNull(stompSession, "TcpConnectionHandler must not be null");
            this.stompSession = stompSession;
        }

        @Override
        public void accept(@Nullable WebSocketSession webSocketSession, @Nullable Throwable throwable) {
            if (throwable != null) {
                this.stompSession.afterConnectFailure(throwable);
            }
        }

        @Override
        public void afterConnectionEstablished(WebSocketSession session) {
            this.session = session;
            this.stompSession.afterConnected(this);
        }

        @Override
        public void handleMessage(WebSocketSession session, WebSocketMessage<?> webSocketMessage) {
            List<Message<byte[]>> messages;
            this.lastReadTime = this.lastReadTime != -1L ? System.currentTimeMillis() : -1L;
            try {
                messages = this.codec.decode(webSocketMessage);
            }
            catch (Throwable ex) {
                this.stompSession.handleFailure(ex);
                return;
            }
            for (Message<byte[]> message2 : messages) {
                this.stompSession.handleMessage(message2);
            }
        }

        @Override
        public void handleTransportError(WebSocketSession session, Throwable ex) {
            this.stompSession.handleFailure(ex);
        }

        @Override
        public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) {
            this.stompSession.afterConnectionClosed();
        }

        @Override
        public boolean supportsPartialMessages() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletableFuture<Void> sendAsync(Message<byte[]> message2) {
            this.updateLastWriteTime();
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            try {
                WebSocketSession session = this.session;
                Assert.state(session != null, "No WebSocketSession available");
                if (this.codec.hasSplittingEncoder()) {
                    for (WebSocketMessage<?> outMessage : this.codec.encodeAndSplit(message2, session.getClass())) {
                        session.sendMessage(outMessage);
                    }
                } else {
                    session.sendMessage(this.codec.encode(message2, session.getClass()));
                }
                future.complete(null);
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
            finally {
                this.updateLastWriteTime();
            }
            return future;
        }

        private void updateLastWriteTime() {
            long lastWriteTime = this.lastWriteTime;
            if (lastWriteTime != -1L) {
                this.lastWriteTime = System.currentTimeMillis();
            }
        }

        @Override
        public void onReadInactivity(Runnable runnable, long duration) {
            Assert.state(WebSocketStompClient.this.getTaskScheduler() != null, "No TaskScheduler configured");
            this.lastReadTime = System.currentTimeMillis();
            Duration delay = Duration.ofMillis(duration / 2L);
            this.readInactivityFuture = WebSocketStompClient.this.getTaskScheduler().scheduleWithFixedDelay(() -> {
                block3: {
                    if (System.currentTimeMillis() - this.lastReadTime > duration) {
                        try {
                            runnable.run();
                        }
                        catch (Throwable ex) {
                            if (!logger.isDebugEnabled()) break block3;
                            logger.debug("ReadInactivityTask failure", ex);
                        }
                    }
                }
            }, delay);
        }

        @Override
        public void onWriteInactivity(Runnable runnable, long duration) {
            Assert.state(WebSocketStompClient.this.getTaskScheduler() != null, "No TaskScheduler configured");
            this.lastWriteTime = System.currentTimeMillis();
            Duration delay = Duration.ofMillis(duration / 2L);
            this.writeInactivityFuture = WebSocketStompClient.this.getTaskScheduler().scheduleWithFixedDelay(() -> {
                block3: {
                    if (System.currentTimeMillis() - this.lastWriteTime > duration) {
                        try {
                            runnable.run();
                        }
                        catch (Throwable ex) {
                            if (!logger.isDebugEnabled()) break block3;
                            logger.debug("WriteInactivityTask failure", ex);
                        }
                    }
                }
            }, delay);
        }

        @Override
        public void close() {
            block3: {
                this.cancelInactivityTasks();
                WebSocketSession session = this.session;
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (IOException ex) {
                        if (!logger.isDebugEnabled()) break block3;
                        logger.debug("Failed to close session: " + session.getId(), ex);
                    }
                }
            }
        }

        private void cancelInactivityTasks() {
            ScheduledFuture<?> readFuture = this.readInactivityFuture;
            this.readInactivityFuture = null;
            WebSocketTcpConnectionHandlerAdapter.cancelFuture(readFuture);
            ScheduledFuture<?> writeFuture = this.writeInactivityFuture;
            this.writeInactivityFuture = null;
            WebSocketTcpConnectionHandlerAdapter.cancelFuture(writeFuture);
            this.lastReadTime = -1L;
            this.lastWriteTime = -1L;
        }

        private static void cancelFuture(@Nullable ScheduledFuture<?> future) {
            if (future != null) {
                try {
                    future.cancel(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static class StompWebSocketMessageCodec {
        private static final StompEncoder ENCODER = new StompEncoder();
        private static final StompDecoder DECODER = new StompDecoder();
        private final BufferingStompDecoder bufferingDecoder;
        @Nullable
        private final SplittingStompEncoder splittingEncoder;

        public StompWebSocketMessageCodec(int inboundMessageSizeLimit, @Nullable Integer outboundMessageSizeLimit) {
            this.bufferingDecoder = new BufferingStompDecoder(DECODER, inboundMessageSizeLimit);
            this.splittingEncoder = outboundMessageSizeLimit != null ? new SplittingStompEncoder(ENCODER, outboundMessageSizeLimit) : null;
        }

        public List<Message<byte[]>> decode(WebSocketMessage<?> webSocketMessage) {
            ByteBuffer byteBuffer;
            List<Message<byte[]>> result = Collections.emptyList();
            if (webSocketMessage instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)webSocketMessage;
                byteBuffer = ByteBuffer.wrap(textMessage.asBytes());
            } else if (webSocketMessage instanceof BinaryMessage) {
                BinaryMessage binaryMessage = (BinaryMessage)webSocketMessage;
                byteBuffer = (ByteBuffer)binaryMessage.getPayload();
            } else {
                return result;
            }
            result = this.bufferingDecoder.decode(byteBuffer);
            if (result.isEmpty() && logger.isTraceEnabled()) {
                logger.trace("Incomplete STOMP frame content received, bufferSize=" + this.bufferingDecoder.getBufferSize() + ", bufferSizeLimit=" + this.bufferingDecoder.getBufferSizeLimit() + ".");
            }
            return result;
        }

        public boolean hasSplittingEncoder() {
            return this.splittingEncoder != null;
        }

        public WebSocketMessage<?> encode(Message<byte[]> message2, Class<? extends WebSocketSession> sessionType) {
            StompHeaderAccessor accessor = StompWebSocketMessageCodec.getStompHeaderAccessor(message2);
            byte[] payload = message2.getPayload();
            byte[] frame = ENCODER.encode(accessor.getMessageHeaders(), payload);
            return StompWebSocketMessageCodec.useBinary(accessor, payload, sessionType) ? new BinaryMessage(frame) : new TextMessage(frame);
        }

        public List<WebSocketMessage<?>> encodeAndSplit(Message<byte[]> message2, Class<? extends WebSocketSession> sessionType) {
            Assert.state(this.splittingEncoder != null, "No SplittingEncoder");
            StompHeaderAccessor accessor = StompWebSocketMessageCodec.getStompHeaderAccessor(message2);
            byte[] payload = message2.getPayload();
            List<byte[]> frames = this.splittingEncoder.encode(accessor.getMessageHeaders(), payload);
            boolean useBinary = StompWebSocketMessageCodec.useBinary(accessor, payload, sessionType);
            ArrayList messages = new ArrayList(frames.size());
            frames.forEach(frame -> messages.add(useBinary ? new BinaryMessage((byte[])frame) : new TextMessage((byte[])frame)));
            return messages;
        }

        private static StompHeaderAccessor getStompHeaderAccessor(Message<byte[]> message2) {
            StompHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(message2, StompHeaderAccessor.class);
            Assert.notNull((Object)accessor, "No StompHeaderAccessor available");
            return accessor;
        }

        private static boolean useBinary(StompHeaderAccessor accessor, byte[] payload, Class<? extends WebSocketSession> sessionType) {
            return payload.length > 0 && !SockJsSession.class.isAssignableFrom(sessionType) && MimeTypeUtils.APPLICATION_OCTET_STREAM.isCompatibleWith(accessor.getContentType());
        }
    }
}

