/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.handler;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BeanCreatingHandlerProvider<T>
implements BeanFactoryAware {
    private final Class<? extends T> handlerType;
    @Nullable
    private AutowireCapableBeanFactory beanFactory;

    public BeanCreatingHandlerProvider(Class<? extends T> handlerType) {
        Assert.notNull(handlerType, "handlerType must not be null");
        this.handlerType = handlerType;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            AutowireCapableBeanFactory autowireCapableBeanFactory;
            this.beanFactory = autowireCapableBeanFactory = (AutowireCapableBeanFactory)beanFactory;
        }
    }

    public void destroy(T handler) {
        if (this.beanFactory != null) {
            this.beanFactory.destroyBean(handler);
        }
    }

    public Class<? extends T> getHandlerType() {
        return this.handlerType;
    }

    public T getHandler() {
        if (this.beanFactory != null) {
            return this.beanFactory.createBean(this.handlerType);
        }
        return BeanUtils.instantiateClass(this.handlerType);
    }

    public String toString() {
        return "BeanCreatingHandlerProvider[handlerType=" + this.handlerType + "]";
    }
}

