/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.handler;

import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public abstract class AbstractWebSocketHandler
implements WebSocketHandler {
    @Override
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
    }

    @Override
    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message2) throws Exception {
        if (message2 instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message2;
            this.handleTextMessage(session, textMessage);
        } else if (message2 instanceof BinaryMessage) {
            BinaryMessage binaryMessage = (BinaryMessage)message2;
            this.handleBinaryMessage(session, binaryMessage);
        } else if (message2 instanceof PongMessage) {
            PongMessage pongMessage = (PongMessage)message2;
            this.handlePongMessage(session, pongMessage);
        } else {
            throw new IllegalStateException("Unexpected WebSocket message type: " + message2);
        }
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message2) throws Exception {
    }

    protected void handleBinaryMessage(WebSocketSession session, BinaryMessage message2) throws Exception {
    }

    protected void handlePongMessage(WebSocketSession session, PongMessage message2) throws Exception {
    }

    @Override
    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
    }

    @Override
    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
    }

    @Override
    public boolean supportsPartialMessages() {
        return false;
    }
}

