/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.socket.config.annotation.ServletWebSocketHandlerRegistry;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

public class WebSocketConfigurationSupport {
    @Nullable
    private ServletWebSocketHandlerRegistry handlerRegistry;

    @Bean
    public HandlerMapping webSocketHandlerMapping(@Qualifier(value="defaultSockJsSchedulerContainer") DefaultSockJsSchedulerContainer schedulerContainer) {
        ServletWebSocketHandlerRegistry registry = this.initHandlerRegistry();
        if (registry.requiresTaskScheduler()) {
            ThreadPoolTaskScheduler scheduler = schedulerContainer.getScheduler();
            Assert.notNull((Object)scheduler, "TaskScheduler is required but not initialized");
            registry.setTaskScheduler(scheduler);
        }
        return registry.getHandlerMapping();
    }

    private ServletWebSocketHandlerRegistry initHandlerRegistry() {
        if (this.handlerRegistry == null) {
            this.handlerRegistry = new ServletWebSocketHandlerRegistry();
            this.registerWebSocketHandlers(this.handlerRegistry);
        }
        return this.handlerRegistry;
    }

    protected void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
    }

    @Bean
    DefaultSockJsSchedulerContainer defaultSockJsSchedulerContainer() {
        return this.initHandlerRegistry().requiresTaskScheduler() ? new DefaultSockJsSchedulerContainer(this.initDefaultSockJsScheduler()) : new DefaultSockJsSchedulerContainer(null);
    }

    private ThreadPoolTaskScheduler initDefaultSockJsScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("SockJS-");
        scheduler.setPoolSize(Runtime.getRuntime().availableProcessors());
        scheduler.setRemoveOnCancelPolicy(true);
        return scheduler;
    }

    static class DefaultSockJsSchedulerContainer
    implements InitializingBean,
    DisposableBean {
        @Nullable
        private final ThreadPoolTaskScheduler scheduler;

        DefaultSockJsSchedulerContainer(@Nullable ThreadPoolTaskScheduler scheduler) {
            this.scheduler = scheduler;
        }

        @Nullable
        public ThreadPoolTaskScheduler getScheduler() {
            return this.scheduler;
        }

        @Override
        public void afterPropertiesSet() throws Exception {
            if (this.scheduler != null) {
                this.scheduler.afterPropertiesSet();
            }
        }

        @Override
        public void destroy() throws Exception {
            if (this.scheduler != null) {
                this.scheduler.destroy();
            }
        }
    }
}

