/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.client.standard;

import jakarta.websocket.ContainerProvider;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.socket.client.ConnectionManagerSupport;
import org.springframework.web.socket.handler.BeanCreatingHandlerProvider;

public class AnnotatedEndpointConnectionManager
extends ConnectionManagerSupport
implements BeanFactoryAware {
    @Nullable
    private final Object endpoint;
    @Nullable
    private final BeanCreatingHandlerProvider<Object> endpointProvider;
    private WebSocketContainer webSocketContainer = ContainerProvider.getWebSocketContainer();
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor("AnnotatedEndpointConnectionManager-");
    @Nullable
    private volatile Session session;

    public AnnotatedEndpointConnectionManager(Object endpoint, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.endpoint = endpoint;
        this.endpointProvider = null;
    }

    public AnnotatedEndpointConnectionManager(Class<?> endpointClass, String uriTemplate, Object ... uriVariables) {
        super(uriTemplate, uriVariables);
        this.endpoint = null;
        this.endpointProvider = new BeanCreatingHandlerProvider(endpointClass);
    }

    public void setWebSocketContainer(WebSocketContainer webSocketContainer) {
        this.webSocketContainer = webSocketContainer;
    }

    public WebSocketContainer getWebSocketContainer() {
        return this.webSocketContainer;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.endpointProvider != null) {
            this.endpointProvider.setBeanFactory(beanFactory);
        }
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, "TaskExecutor must not be null");
        this.taskExecutor = taskExecutor;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    @Override
    public boolean isConnected() {
        Session session = this.session;
        return session != null && session.isOpen();
    }

    @Override
    protected void openConnection() {
        this.taskExecutor.execute(() -> {
            try {
                Object endpointToUse;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Connecting to WebSocket at " + this.getUri());
                }
                if ((endpointToUse = this.endpoint) == null) {
                    Assert.state(this.endpointProvider != null, "No endpoint set");
                    endpointToUse = this.endpointProvider.getHandler();
                }
                this.session = this.webSocketContainer.connectToServer(endpointToUse, this.getUri());
                this.logger.info("Successfully connected to WebSocket");
            }
            catch (Throwable ex) {
                this.logger.error("Failed to connect to WebSocket", ex);
            }
        });
    }

    @Override
    protected void closeConnection() throws Exception {
        try {
            Session session = this.session;
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
        finally {
            this.session = null;
        }
    }
}

