/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.freemarker;

import freemarker.template.Configuration;
import java.util.Locale;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractTemplateViewResolver;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

public class FreeMarkerViewResolver
extends AbstractTemplateViewResolver {
    public FreeMarkerViewResolver() {
        this.setViewClass(this.requiredViewClass());
    }

    public FreeMarkerViewResolver(String prefix, String suffix) {
        this();
        this.setPrefix(prefix);
        this.setSuffix(suffix);
    }

    @Override
    protected Class<?> requiredViewClass() {
        return FreeMarkerView.class;
    }

    @Override
    protected AbstractUrlBasedView instantiateView() {
        return this.getViewClass() == FreeMarkerView.class ? new FreeMarkerView() : super.instantiateView();
    }

    @Override
    @Nullable
    protected View loadView(String viewName, Locale locale) throws Exception {
        View view2 = super.loadView(viewName, locale);
        if (view2 instanceof FreeMarkerView) {
            FreeMarkerView freeMarkerView = (FreeMarkerView)view2;
            this.postProcessView(freeMarkerView);
        }
        return view2;
    }

    protected void postProcessView(FreeMarkerView freeMarkerView) {
        Configuration configuration;
        if (this.getContentType() != null) {
            return;
        }
        String encoding = freeMarkerView.getEncoding();
        if (encoding == null && (configuration = freeMarkerView.obtainConfiguration()).isDefaultEncodingExplicitlySet()) {
            encoding = configuration.getDefaultEncoding();
        }
        if (StringUtils.hasText(encoding)) {
            String contentType = "text/html;charset=" + encoding;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting Content-Type for view [%s] to: %s".formatted(freeMarkerView, contentType));
            }
            freeMarkerView.setContentType(contentType);
        }
    }
}

