/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.freemarker;

import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.ext.jakarta.jsp.TaglibFactory;
import freemarker.ext.jakarta.servlet.AllHttpScopesHashModel;
import freemarker.ext.jakarta.servlet.HttpRequestHashModel;
import freemarker.ext.jakarta.servlet.HttpRequestParametersHashModel;
import freemarker.ext.jakarta.servlet.HttpSessionHashModel;
import freemarker.ext.jakarta.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.AbstractTemplateView;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class FreeMarkerView
extends AbstractTemplateView {
    @Nullable
    private String encoding;
    @Nullable
    private Configuration configuration;
    @Nullable
    private TaglibFactory taglibFactory;
    @Nullable
    private ServletContextHashModel servletContextHashModel;

    public void setEncoding(@Nullable String encoding) {
        this.encoding = encoding;
    }

    public void setCharset(@Nullable Charset charset) {
        this.encoding = charset != null ? charset.name() : null;
    }

    @Nullable
    protected String getEncoding() {
        return this.encoding;
    }

    public void setConfiguration(@Nullable Configuration configuration) {
        this.configuration = configuration;
    }

    @Nullable
    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Configuration obtainConfiguration() {
        Configuration configuration = this.getConfiguration();
        Assert.state(configuration != null, "No Configuration set");
        return configuration;
    }

    @Override
    protected void initServletContext(ServletContext servletContext) throws BeansException {
        if (this.getConfiguration() != null) {
            this.taglibFactory = new TaglibFactory(servletContext);
        } else {
            FreeMarkerConfig config = this.autodetectConfiguration();
            this.setConfiguration(config.getConfiguration());
            this.taglibFactory = config.getTaglibFactory();
        }
        GenericServletAdapter servlet = new GenericServletAdapter();
        try {
            servlet.init(new DelegatingServletConfig());
        }
        catch (ServletException ex) {
            throw new BeanInitializationException("Initialization of GenericServlet adapter failed", ex);
        }
        this.servletContextHashModel = new ServletContextHashModel((GenericServlet)servlet, this.getObjectWrapper());
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        try {
            return BeanFactoryUtils.beanOfTypeIncludingAncestors(this.obtainApplicationContext(), FreeMarkerConfig.class, true, false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this web application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", ex);
        }
    }

    protected ObjectWrapper getObjectWrapper() {
        ObjectWrapper ow = this.obtainConfiguration().getObjectWrapper();
        return ow != null ? ow : new DefaultObjectWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS).build();
    }

    @Override
    public boolean checkResource(Locale locale) throws Exception {
        String url = this.getUrl();
        Assert.state(url != null, "'url' not set");
        try {
            this.getTemplate(url, locale);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (ParseException ex) {
            throw new ApplicationContextException("Failed to parse [" + url + "]", ex);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Failed to load [" + url + "]", ex);
        }
    }

    @Override
    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeHelpers(model, request);
        this.doRender(model, request, response);
    }

    protected void exposeHelpers(Map<String, Object> model, HttpServletRequest request) throws Exception {
    }

    protected void doRender(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.exposeModelAsRequestAttributes(model, request);
        SimpleHash fmModel = this.buildTemplateModel(model, request, response);
        Locale locale = RequestContextUtils.getLocale(request);
        this.processTemplate(this.getTemplate(locale), fmModel, response);
    }

    protected SimpleHash buildTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        AllHttpScopesHashModel fmModel = new AllHttpScopesHashModel(this.getObjectWrapper(), this.getServletContext(), request);
        fmModel.put("JspTaglibs", (Object)this.taglibFactory);
        fmModel.put("Application", (Object)this.servletContextHashModel);
        fmModel.put("Session", (Object)this.buildSessionModel(request, response));
        fmModel.put("Request", (Object)new HttpRequestHashModel(request, response, this.getObjectWrapper()));
        fmModel.put("RequestParameters", (Object)new HttpRequestParametersHashModel(request));
        fmModel.putAll(model);
        return fmModel;
    }

    private HttpSessionHashModel buildSessionModel(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return new HttpSessionHashModel(session, this.getObjectWrapper());
        }
        return new HttpSessionHashModel(null, request, response, this.getObjectWrapper());
    }

    protected Template getTemplate(Locale locale) throws IOException {
        String url = this.getUrl();
        Assert.state(url != null, "'url' not set");
        return this.getTemplate(url, locale);
    }

    protected Template getTemplate(String name, Locale locale) throws IOException {
        return this.getEncoding() != null ? this.obtainConfiguration().getTemplate(name, locale, this.getEncoding()) : this.obtainConfiguration().getTemplate(name, locale);
    }

    protected void processTemplate(Template template, SimpleHash model, HttpServletResponse response) throws IOException, TemplateException {
        Environment env = template.createProcessingEnvironment((Object)model, (Writer)response.getWriter());
        env.setOutputEncoding(response.getCharacterEncoding());
        env.process();
    }

    private static class GenericServletAdapter
    extends GenericServlet {
        private GenericServletAdapter() {
        }

        @Override
        public void service(ServletRequest servletRequest, ServletResponse servletResponse) {
        }
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        @Override
        @Nullable
        public String getServletName() {
            return FreeMarkerView.this.getBeanName();
        }

        @Override
        @Nullable
        public ServletContext getServletContext() {
            return FreeMarkerView.this.getServletContext();
        }

        @Override
        @Nullable
        public String getInitParameter(String paramName) {
            return null;
        }

        @Override
        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(Collections.emptySet());
        }
    }
}

