/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.resource;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceHandlerUtils;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.springframework.web.util.ServletRequestPathUtils;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.UrlPathHelper;

public class PathResourceResolver
extends AbstractResourceResolver {
    @Nullable
    private Resource[] allowedLocations;
    private final Map<Resource, Charset> locationCharsets = new HashMap<Resource, Charset>(4);
    @Nullable
    private UrlPathHelper urlPathHelper;

    public void setAllowedLocations(Resource ... locations) {
        this.allowedLocations = locations;
    }

    @Nullable
    public Resource[] getAllowedLocations() {
        return this.allowedLocations;
    }

    public void setLocationCharsets(Map<Resource, Charset> locationCharsets) {
        this.locationCharsets.clear();
        this.locationCharsets.putAll(locationCharsets);
    }

    public Map<Resource, Charset> getLocationCharsets() {
        return Collections.unmodifiableMap(this.locationCharsets);
    }

    public void setUrlPathHelper(@Nullable UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    @Nullable
    public UrlPathHelper getUrlPathHelper() {
        return this.urlPathHelper;
    }

    @Override
    @Nullable
    protected Resource resolveResourceInternal(@Nullable HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.getResource(requestPath, request, locations);
    }

    @Override
    @Nullable
    protected String resolveUrlPathInternal(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return StringUtils.hasText(resourcePath) && this.getResource(resourcePath, null, locations) != null ? resourcePath : null;
    }

    @Nullable
    private Resource getResource(String resourcePath, @Nullable HttpServletRequest request, List<? extends Resource> locations) {
        for (Resource resource : locations) {
            try {
                String pathToUse = this.encodeOrDecodeIfNecessary(resourcePath, request, resource);
                Resource resource2 = this.getResource(pathToUse, resource);
                if (resource2 == null) continue;
                return resource2;
            }
            catch (IOException ex) {
                if (!this.logger.isDebugEnabled()) continue;
                String error = "Skip location [" + resource + "] due to error";
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(error, ex);
                    continue;
                }
                this.logger.debug(error + ": " + ex.getMessage());
            }
        }
        return null;
    }

    @Nullable
    protected Resource getResource(String resourcePath, Resource location) throws IOException {
        Resource resource = location.createRelative(resourcePath);
        if (resource.isReadable()) {
            if (this.checkResource(resource, location)) {
                return resource;
            }
            if (this.logger.isWarnEnabled()) {
                Resource[] allowed = this.getAllowedLocations();
                this.logger.warn(LogFormatUtils.formatValue("Resource path \"" + resourcePath + "\" was successfully resolved but resource \"" + resource + "\" is neither under the current location \"" + location + "\" nor under any of the allowed locations " + (allowed != null ? Arrays.asList(allowed) : "[]"), -1, true));
            }
        }
        return null;
    }

    protected boolean checkResource(Resource resource, Resource location) throws IOException {
        if (ResourceHandlerUtils.isResourceUnderLocation(location, resource)) {
            return true;
        }
        Resource[] allowedLocations = this.getAllowedLocations();
        if (allowedLocations != null) {
            for (Resource current : allowedLocations) {
                if (!ResourceHandlerUtils.isResourceUnderLocation(current, resource)) continue;
                return true;
            }
        }
        return false;
    }

    private String encodeOrDecodeIfNecessary(String path, @Nullable HttpServletRequest request, Resource location) {
        if (request != null) {
            boolean usesPathPattern;
            boolean bl = usesPathPattern = ServletRequestPathUtils.hasCachedPath(request) && ServletRequestPathUtils.getCachedPath(request) instanceof PathContainer;
            if (this.shouldDecodeRelativePath(location, usesPathPattern)) {
                return UriUtils.decode(path, StandardCharsets.UTF_8);
            }
            if (this.shouldEncodeRelativePath(location, usesPathPattern)) {
                Charset charset = this.locationCharsets.getOrDefault(location, StandardCharsets.UTF_8);
                StringBuilder sb = new StringBuilder();
                StringTokenizer tokenizer = new StringTokenizer(path, "/");
                while (tokenizer.hasMoreTokens()) {
                    String value = UriUtils.encode(tokenizer.nextToken(), charset);
                    sb.append(value);
                    sb.append('/');
                }
                if (!path.endsWith("/")) {
                    sb.setLength(sb.length() - 1);
                }
                return sb.toString();
            }
        }
        return path;
    }

    private boolean shouldDecodeRelativePath(Resource location, boolean usesPathPattern) {
        return !(location instanceof UrlResource) && (usesPathPattern || this.urlPathHelper != null && !this.urlPathHelper.isUrlDecode());
    }

    private boolean shouldEncodeRelativePath(Resource location, boolean usesPathPattern) {
        return location instanceof UrlResource && !usesPathPattern && this.urlPathHelper != null && this.urlPathHelper.isUrlDecode();
    }
}

