/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.server.DelegatingServerHttpResponse;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.filter.ShallowEtagHeaderFilter;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.method.annotation.ReactiveTypeHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import org.springframework.web.servlet.view.FragmentsRendering;

public class ResponseBodyEmitterReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final List<HttpMessageConverter<?>> sseMessageConverters;
    private final ReactiveTypeHandler reactiveHandler;
    private final List<ViewResolver> viewResolvers;
    private final LocaleResolver localeResolver;

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters) {
        this(messageConverters, ReactiveAdapterRegistry.getSharedInstance(), new SyncTaskExecutor(), new ContentNegotiationManager());
    }

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters, ReactiveAdapterRegistry registry, TaskExecutor executor, ContentNegotiationManager manager) {
        this(messageConverters, registry, executor, manager, Collections.emptyList(), null);
    }

    public ResponseBodyEmitterReturnValueHandler(List<HttpMessageConverter<?>> messageConverters, ReactiveAdapterRegistry registry, TaskExecutor executor, ContentNegotiationManager manager, List<ViewResolver> viewResolvers, @Nullable LocaleResolver localeResolver) {
        Assert.notEmpty(messageConverters, "HttpMessageConverter List must not be empty");
        this.sseMessageConverters = ResponseBodyEmitterReturnValueHandler.initSseConverters(messageConverters);
        this.reactiveHandler = new ReactiveTypeHandler(registry, executor, manager, null);
        this.viewResolvers = viewResolvers;
        this.localeResolver = localeResolver != null ? localeResolver : new AcceptHeaderLocaleResolver();
    }

    private static List<HttpMessageConverter<?>> initSseConverters(List<HttpMessageConverter<?>> converters) {
        for (HttpMessageConverter<String> httpMessageConverter : converters) {
            if (!httpMessageConverter.canWrite(String.class, MediaType.TEXT_PLAIN)) continue;
            return converters;
        }
        ArrayList result = new ArrayList(converters.size() + 1);
        result.add(new StringHttpMessageConverter(StandardCharsets.UTF_8));
        result.addAll(converters);
        return result;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        Class<?> bodyType = ResponseEntity.class.isAssignableFrom(returnType.getParameterType()) ? ResolvableType.forMethodParameter(returnType).getGeneric(new int[0]).resolve() : returnType.getParameterType();
        return bodyType != null && (ResponseBodyEmitter.class.isAssignableFrom(bodyType) || this.reactiveHandler.isReactiveType(bodyType));
    }

    @Override
    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        DefaultSseEmitterHandler emitterHandler;
        ResponseBodyEmitter emitter;
        HttpServletRequest request;
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        HttpServletResponse response = webRequest.getNativeResponse(HttpServletResponse.class);
        Assert.state(response != null, "No HttpServletResponse");
        ServerHttpResponse outputMessage = new ServletServerHttpResponse(response);
        if (returnValue instanceof ResponseEntity) {
            ResponseEntity responseEntity = (ResponseEntity)returnValue;
            response.setStatus(responseEntity.getStatusCode().value());
            outputMessage.getHeaders().putAll(responseEntity.getHeaders());
            returnValue = responseEntity.getBody();
            returnType = returnType.nested();
            if (returnValue == null) {
                mavContainer.setRequestHandled(true);
                outputMessage.flush();
                return;
            }
        }
        Assert.state((request = webRequest.getNativeRequest(HttpServletRequest.class)) != null, "No ServletRequest");
        if (returnValue instanceof ResponseBodyEmitter) {
            ResponseBodyEmitter responseBodyEmitter;
            emitter = responseBodyEmitter = (ResponseBodyEmitter)returnValue;
        } else {
            emitter = this.reactiveHandler.handleValue(returnValue, returnType, mavContainer, webRequest);
            if (emitter == null) {
                outputMessage.getHeaders().forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(headerName, headerValues) -> {
                    for (String headerValue : headerValues) {
                        response.addHeader((String)headerName, headerValue);
                    }
                }));
                return;
            }
        }
        emitter.extendResponse(outputMessage);
        ShallowEtagHeaderFilter.disableContentCaching(request);
        outputMessage = new StreamingServletServerHttpResponse(outputMessage);
        try {
            DeferredResult result = new DeferredResult(emitter.getTimeout());
            WebAsyncUtils.getAsyncManager(webRequest).startDeferredResultProcessing(result, mavContainer);
            FragmentHandler handler = new FragmentHandler(request, response, this.viewResolvers, this.localeResolver);
            emitterHandler = new DefaultSseEmitterHandler(this.sseMessageConverters, handler, outputMessage, result);
        }
        catch (Throwable ex) {
            emitter.initializeWithError(ex);
            throw ex;
        }
        emitter.initialize(emitterHandler);
    }

    private static class StreamingServletServerHttpResponse
    extends DelegatingServerHttpResponse {
        private final HttpHeaders mutableHeaders = new HttpHeaders();

        public StreamingServletServerHttpResponse(ServerHttpResponse delegate) {
            super(delegate);
            this.mutableHeaders.putAll(delegate.getHeaders());
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.mutableHeaders;
        }
    }

    private static final class FragmentHandler {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final List<ViewResolver> viewResolvers;
        private final Locale locale;
        private final Charset charset;
        private final ServletRequestAttributes requestAttributes;

        public FragmentHandler(HttpServletRequest request, HttpServletResponse response, List<ViewResolver> viewResolvers, LocaleResolver localeResolver) {
            this.request = request;
            this.response = response;
            this.viewResolvers = viewResolvers;
            this.charset = FragmentHandler.initCharset(response);
            this.locale = localeResolver.resolveLocale(request);
            this.requestAttributes = new ServletWebRequest(this.request);
        }

        private static Charset initCharset(HttpServletResponse response) {
            MediaType contentType;
            String s = response.getHeader("Content-Type");
            if (StringUtils.hasText(s) && (contentType = MediaType.valueOf(s)).getCharset() != null) {
                return contentType.getCharset();
            }
            return StandardCharsets.UTF_8;
        }

        public void handle(ModelAndView modelAndView) throws IOException {
            RequestContextHolder.setRequestAttributes(this.requestAttributes);
            try {
                FragmentHttpServletResponse fragmentResponse = new FragmentHttpServletResponse(this.response, this.charset);
                FragmentsRendering render = FragmentsRendering.with(List.of(modelAndView)).build();
                render.resolveNestedViews(this::resolveViewName, this.locale);
                render.render(modelAndView.getModel(), this.request, fragmentResponse);
                byte[] content = fragmentResponse.getFragmentContent();
                this.response.getOutputStream().write(content);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to render " + modelAndView, ex);
            }
            finally {
                RequestContextHolder.resetRequestAttributes();
            }
        }

        @Nullable
        public View resolveViewName(String viewName, Locale locale) throws Exception {
            for (ViewResolver resolver : this.viewResolvers) {
                View view2 = resolver.resolveViewName(viewName, locale);
                if (view2 == null) continue;
                return view2;
            }
            return null;
        }
    }

    private static final class DefaultSseEmitterHandler
    implements ResponseBodyEmitter.Handler {
        private final List<HttpMessageConverter<?>> messageConverters;
        private final FragmentHandler fragmentHandler;
        private final ServerHttpResponse outputMessage;
        private final DeferredResult<?> deferredResult;

        public DefaultSseEmitterHandler(List<HttpMessageConverter<?>> messageConverters, FragmentHandler fragmentHandler, ServerHttpResponse outputMessage, DeferredResult<?> result) {
            this.messageConverters = messageConverters;
            this.fragmentHandler = fragmentHandler;
            this.outputMessage = outputMessage;
            this.deferredResult = result;
        }

        @Override
        public void send(Object data, @Nullable MediaType mediaType) throws IOException {
            this.sendInternal(data, mediaType);
            this.outputMessage.flush();
        }

        @Override
        public void send(Set<ResponseBodyEmitter.DataWithMediaType> items) throws IOException {
            for (ResponseBodyEmitter.DataWithMediaType item : items) {
                this.sendInternal(item.getData(), item.getMediaType());
            }
            this.outputMessage.flush();
        }

        private <T> void sendInternal(T data, @Nullable MediaType mediaType) throws IOException {
            if (data instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)data;
                this.fragmentHandler.handle(mav);
                return;
            }
            for (HttpMessageConverter<?> converter : this.messageConverters) {
                if (!converter.canWrite(data.getClass(), mediaType)) continue;
                converter.write(data, mediaType, this.outputMessage);
                return;
            }
            throw new IllegalArgumentException("No suitable converter for " + data.getClass());
        }

        @Override
        public void complete() {
            try {
                this.outputMessage.flush();
                this.deferredResult.setResult(null);
            }
            catch (IOException ex) {
                this.deferredResult.setErrorResult(ex);
            }
        }

        @Override
        public void completeWithError(Throwable failure) {
            this.deferredResult.setErrorResult(failure);
        }

        @Override
        public void onTimeout(Runnable callback) {
            this.deferredResult.onTimeout(callback);
        }

        @Override
        public void onError(Consumer<Throwable> callback) {
            this.deferredResult.onError(callback);
        }

        @Override
        public void onCompletion(Runnable callback) {
            this.deferredResult.onCompletion(callback);
        }
    }

    private static final class FragmentServletOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        private FragmentServletOutputStream() {
        }

        @Override
        public void write(int b) {
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.outputStream.write(b, off, len);
        }

        @Override
        public boolean isReady() {
            return false;
        }

        @Override
        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException();
        }

        public String toString(Charset charset) {
            return this.outputStream.toString(charset);
        }
    }

    private static final class FragmentHttpServletResponse
    extends HttpServletResponseWrapper {
        private final FragmentServletOutputStream outputStream = new FragmentServletOutputStream();
        private final PrintWriter writer = new PrintWriter(this.outputStream);
        private final Charset charset;

        public FragmentHttpServletResponse(HttpServletResponse delegate, Charset charset) {
            super(delegate);
            this.charset = charset;
        }

        @Override
        public void setContentType(String type) {
        }

        @Override
        public void setCharacterEncoding(String charset) {
        }

        @Override
        public void setContentLength(int len) {
        }

        @Override
        public ServletOutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public PrintWriter getWriter() {
            return this.writer;
        }

        public byte[] getFragmentContent() {
            this.writer.flush();
            String content = this.outputStream.toString(this.charset);
            content = content.replace("\n", "\ndata:");
            return content.getBytes(this.charset);
        }
    }
}

