/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpRequest;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.SmartHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.ValidationAnnotationUtils;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyAdviceChain;

public abstract class AbstractMessageConverterMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Set<HttpMethod> SUPPORTED_METHODS = Set.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private static final Object NO_VALUE = new Object();
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final List<HttpMessageConverter<?>> messageConverters;
    private final RequestResponseBodyAdviceChain advice;

    public AbstractMessageConverterMethodArgumentResolver(List<HttpMessageConverter<?>> converters) {
        this(converters, null);
    }

    public AbstractMessageConverterMethodArgumentResolver(List<HttpMessageConverter<?>> converters, @Nullable List<Object> requestResponseBodyAdvice) {
        Assert.notEmpty(converters, "'messageConverters' must not be empty");
        this.messageConverters = converters;
        this.advice = new RequestResponseBodyAdviceChain(requestResponseBodyAdvice);
    }

    RequestResponseBodyAdviceChain getAdvice() {
        return this.advice;
    }

    @Nullable
    protected Object readWithMessageConverters(NativeWebRequest webRequest, MethodParameter parameter, Type paramType) throws IOException, HttpMediaTypeNotSupportedException, HttpMessageNotReadableException {
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        return this.readWithMessageConverters(inputMessage, parameter, paramType);
    }

    @Nullable
    protected <T> Object readWithMessageConverters(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType) throws IOException, HttpMediaTypeNotSupportedException, HttpMessageNotReadableException {
        HttpMethod httpMethod;
        MediaType contentType;
        Class<?> clazz;
        Class<?> contextClass = parameter.getContainingClass();
        Class<?> targetClass = targetType instanceof Class ? (clazz = (Class<?>)targetType) : null;
        ResolvableType resolvableType = ResolvableType.forMethodParameter(parameter);
        if (targetClass == null) {
            targetClass = resolvableType.resolve();
        }
        boolean noContentType = false;
        try {
            contentType = inputMessage.getHeaders().getContentType();
        }
        catch (InvalidMediaTypeException ex) {
            throw new HttpMediaTypeNotSupportedException(ex.getMessage(), this.getSupportedMediaTypes(targetClass != null ? targetClass : Object.class));
        }
        if (contentType == null) {
            noContentType = true;
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        if (inputMessage instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)((Object)inputMessage);
            httpMethod = httpRequest.getMethod();
        } else {
            httpMethod = null;
        }
        HttpMethod httpMethod2 = httpMethod;
        Object body2 = NO_VALUE;
        EmptyBodyCheckingHttpInputMessage message2 = null;
        try {
            ResolvableType targetResolvableType = null;
            message2 = new EmptyBodyCheckingHttpInputMessage(inputMessage);
            for (HttpMessageConverter<?> converter : this.messageConverters) {
                Class<?> converterClass = converter.getClass();
                ConverterType converterTypeToUse = null;
                if (converter instanceof GenericHttpMessageConverter) {
                    GenericHttpMessageConverter genericConverter = (GenericHttpMessageConverter)converter;
                    if (genericConverter.canRead(targetType, contextClass, contentType)) {
                        converterTypeToUse = ConverterType.GENERIC;
                    }
                } else if (converter instanceof SmartHttpMessageConverter) {
                    SmartHttpMessageConverter smartConverter = (SmartHttpMessageConverter)converter;
                    if (targetResolvableType == null) {
                        targetResolvableType = this.getNestedTypeIfNeeded(resolvableType);
                    }
                    if (smartConverter.canRead(targetResolvableType, contentType)) {
                        converterTypeToUse = ConverterType.SMART;
                    }
                } else if (targetClass != null && converter.canRead(targetClass, contentType)) {
                    converterTypeToUse = ConverterType.BASE;
                }
                if (converterTypeToUse == null) continue;
                if (message2.hasBody()) {
                    HttpInputMessage msgToUse = this.getAdvice().beforeBodyRead(message2, parameter, targetType, converterClass);
                    body2 = switch (converterTypeToUse) {
                        default -> throw new IncompatibleClassChangeError();
                        case ConverterType.BASE -> converter.read(targetClass, msgToUse);
                        case ConverterType.GENERIC -> ((GenericHttpMessageConverter)converter).read(targetType, contextClass, msgToUse);
                        case ConverterType.SMART -> ((SmartHttpMessageConverter)converter).read(targetResolvableType, msgToUse, null);
                    };
                    body2 = this.getAdvice().afterBodyRead(body2, msgToUse, parameter, targetType, converterClass);
                    break;
                }
                body2 = this.getAdvice().handleEmptyBody(null, message2, parameter, targetType, converterClass);
                break;
            }
            if (body2 == NO_VALUE && noContentType && !message2.hasBody()) {
                body2 = this.getAdvice().handleEmptyBody(null, message2, parameter, targetType, NoContentTypeHttpMessageConverter.class);
            }
        }
        catch (IOException ex) {
            throw new HttpMessageNotReadableException("I/O error while reading input message", ex, inputMessage);
        }
        finally {
            if (message2 != null && message2.hasBody()) {
                this.closeStreamIfNecessary(message2.getBody());
            }
        }
        if (body2 == NO_VALUE) {
            if (httpMethod2 == null || !SUPPORTED_METHODS.contains(httpMethod2) || noContentType && !message2.hasBody()) {
                return null;
            }
            throw new HttpMediaTypeNotSupportedException(contentType, this.getSupportedMediaTypes(targetClass != null ? targetClass : Object.class), httpMethod2);
        }
        MediaType selectedContentType = contentType;
        Object theBody = body2;
        LogFormatUtils.traceDebug(this.logger, traceOn -> {
            String formatted = LogFormatUtils.formatValue(theBody, traceOn == false);
            return "Read \"" + selectedContentType + "\" to [" + formatted + "]";
        });
        return body2;
    }

    protected ResolvableType getNestedTypeIfNeeded(ResolvableType type) {
        ResolvableType genericType = type;
        if (Optional.class.isAssignableFrom(genericType.toClass())) {
            genericType = genericType.getNested(2);
        }
        if (HttpEntity.class.isAssignableFrom(genericType.toClass())) {
            genericType = genericType.getNested(2);
        }
        return genericType;
    }

    protected ServletServerHttpRequest createInputMessage(NativeWebRequest webRequest) {
        HttpServletRequest servletRequest = webRequest.getNativeRequest(HttpServletRequest.class);
        Assert.state(servletRequest != null, "No HttpServletRequest");
        return new ServletServerHttpRequest(servletRequest);
    }

    protected void validateIfApplicable(WebDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] validationHints = ValidationAnnotationUtils.determineValidationHints(ann);
            if (validationHints == null) continue;
            binder.validate(validationHints);
            break;
        }
    }

    protected boolean isBindExceptionRequired(WebDataBinder binder, MethodParameter parameter) {
        int i2 = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getExecutable().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i2 + 1 && Errors.class.isAssignableFrom(paramTypes[i2 + 1]);
        return !hasBindingResult;
    }

    protected List<MediaType> getSupportedMediaTypes(Class<?> clazz) {
        LinkedHashSet<MediaType> mediaTypeSet = new LinkedHashSet<MediaType>();
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            mediaTypeSet.addAll(converter.getSupportedMediaTypes(clazz));
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>(mediaTypeSet);
        MimeTypeUtils.sortBySpecificity(result);
        return result;
    }

    @Nullable
    protected Object adaptArgumentIfNecessary(@Nullable Object arg, MethodParameter parameter) {
        if (parameter.getParameterType() == Optional.class) {
            Object[] array;
            Collection collection;
            if (arg == null || arg instanceof Collection && (collection = (Collection)arg).isEmpty() || arg instanceof Object[] && (array = (Object[])arg).length == 0) {
                return Optional.empty();
            }
            return Optional.of(arg);
        }
        return arg;
    }

    void closeStreamIfNecessary(InputStream body2) {
    }

    private static class EmptyBodyCheckingHttpInputMessage
    implements HttpInputMessage {
        private final HttpHeaders headers;
        @Nullable
        private final InputStream body;

        public EmptyBodyCheckingHttpInputMessage(HttpInputMessage inputMessage) throws IOException {
            this.headers = inputMessage.getHeaders();
            InputStream inputStream = inputMessage.getBody();
            if (inputStream.markSupported()) {
                inputStream.mark(1);
                this.body = inputStream.read() != -1 ? inputStream : null;
                inputStream.reset();
            } else {
                PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
                int b = pushbackInputStream.read();
                if (b == -1) {
                    this.body = null;
                } else {
                    this.body = pushbackInputStream;
                    pushbackInputStream.unread(b);
                }
            }
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.headers;
        }

        @Override
        public InputStream getBody() {
            return this.body != null ? this.body : InputStream.nullInputStream();
        }

        public boolean hasBody() {
            return this.body != null;
        }
    }

    protected static enum ConverterType {
        BASE,
        GENERIC,
        SMART;

    }

    private static class NoContentTypeHttpMessageConverter
    implements HttpMessageConverter<String> {
        private NoContentTypeHttpMessageConverter() {
        }

        @Override
        public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
            return false;
        }

        @Override
        public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
            return false;
        }

        @Override
        public List<MediaType> getSupportedMediaTypes() {
            return Collections.emptyList();
        }

        @Override
        public String read(Class<? extends String> clazz, HttpInputMessage inputMessage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(String s, @Nullable MediaType contentType, HttpOutputMessage outputMessage) {
            throw new UnsupportedOperationException();
        }
    }
}

