/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;
import org.springframework.web.service.annotation.HttpExchange;
import org.springframework.web.service.invoker.CookieValueArgumentResolver;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpMethodArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import org.springframework.web.service.invoker.HttpServiceMethod;
import org.springframework.web.service.invoker.PathVariableArgumentResolver;
import org.springframework.web.service.invoker.RequestAttributeArgumentResolver;
import org.springframework.web.service.invoker.RequestBodyArgumentResolver;
import org.springframework.web.service.invoker.RequestHeaderArgumentResolver;
import org.springframework.web.service.invoker.RequestParamArgumentResolver;
import org.springframework.web.service.invoker.RequestPartArgumentResolver;
import org.springframework.web.service.invoker.UriBuilderFactoryArgumentResolver;
import org.springframework.web.service.invoker.UrlArgumentResolver;

public final class HttpServiceProxyFactory {
    private final HttpExchangeAdapter exchangeAdapter;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    @Nullable
    private final StringValueResolver embeddedValueResolver;

    private HttpServiceProxyFactory(HttpExchangeAdapter exchangeAdapter, List<HttpServiceArgumentResolver> argumentResolvers, @Nullable StringValueResolver embeddedValueResolver) {
        this.exchangeAdapter = exchangeAdapter;
        this.argumentResolvers = argumentResolvers;
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public <S> S createClient(Class<S> serviceType) {
        List<HttpServiceMethod> httpServiceMethods = MethodIntrospector.selectMethods(serviceType, this::isExchangeMethod).stream().map(method -> this.createHttpServiceMethod(serviceType, (Method)method)).toList();
        return ProxyFactory.getProxy(serviceType, new HttpServiceMethodInterceptor(httpServiceMethods));
    }

    private boolean isExchangeMethod(Method method) {
        return AnnotatedElementUtils.hasAnnotation(method, HttpExchange.class);
    }

    private <S> HttpServiceMethod createHttpServiceMethod(Class<S> serviceType, Method method) {
        Assert.notNull(this.argumentResolvers, "No argument resolvers: afterPropertiesSet was not called");
        return new HttpServiceMethod(method, serviceType, this.argumentResolvers, this.exchangeAdapter, this.embeddedValueResolver);
    }

    public static Builder builderFor(HttpExchangeAdapter exchangeAdapter) {
        return new Builder().exchangeAdapter(exchangeAdapter);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class HttpServiceMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, HttpServiceMethod> httpServiceMethods;

        private HttpServiceMethodInterceptor(List<HttpServiceMethod> methods) {
            this.httpServiceMethods = methods.stream().collect(Collectors.toMap(HttpServiceMethod::getMethod, Function.identity()));
        }

        @Override
        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            HttpServiceMethod httpServiceMethod = this.httpServiceMethods.get(method);
            if (httpServiceMethod != null) {
                Object[] arguments = KotlinDetector.isSuspendingFunction(method) ? HttpServiceMethodInterceptor.resolveCoroutinesArguments(invocation.getArguments()) : invocation.getArguments();
                return httpServiceMethod.invoke(arguments);
            }
            if (method.isDefault() && invocation instanceof ReflectiveMethodInvocation) {
                ReflectiveMethodInvocation reflectiveMethodInvocation = (ReflectiveMethodInvocation)invocation;
                Object proxy = reflectiveMethodInvocation.getProxy();
                return InvocationHandler.invokeDefault(proxy, method, invocation.getArguments());
            }
            throw new IllegalStateException("Unexpected method invocation: " + method);
        }

        private static Object[] resolveCoroutinesArguments(Object[] args2) {
            Object[] functionArgs = new Object[args2.length - 1];
            System.arraycopy(args2, 0, functionArgs, 0, args2.length - 1);
            return functionArgs;
        }
    }

    public static final class Builder {
        @Nullable
        private HttpExchangeAdapter exchangeAdapter;
        private final List<HttpServiceArgumentResolver> customArgumentResolvers = new ArrayList<HttpServiceArgumentResolver>();
        @Nullable
        private ConversionService conversionService;
        @Nullable
        private StringValueResolver embeddedValueResolver;

        private Builder() {
        }

        public Builder exchangeAdapter(HttpExchangeAdapter adapter) {
            this.exchangeAdapter = adapter;
            return this;
        }

        public Builder customArgumentResolver(HttpServiceArgumentResolver resolver) {
            this.customArgumentResolvers.add(resolver);
            return this;
        }

        public Builder conversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        public Builder embeddedValueResolver(StringValueResolver embeddedValueResolver) {
            this.embeddedValueResolver = embeddedValueResolver;
            return this;
        }

        public HttpServiceProxyFactory build() {
            Assert.notNull((Object)this.exchangeAdapter, "HttpClientAdapter is required");
            return new HttpServiceProxyFactory(this.exchangeAdapter, this.initArgumentResolvers(), this.embeddedValueResolver);
        }

        private List<HttpServiceArgumentResolver> initArgumentResolvers() {
            ArrayList<HttpServiceArgumentResolver> resolvers = new ArrayList<HttpServiceArgumentResolver>(this.customArgumentResolvers);
            ConversionService service = this.conversionService != null ? this.conversionService : new DefaultFormattingConversionService();
            resolvers.add(new RequestHeaderArgumentResolver(service));
            resolvers.add(new RequestBodyArgumentResolver(this.exchangeAdapter));
            resolvers.add(new PathVariableArgumentResolver(service));
            resolvers.add(new RequestParamArgumentResolver(service));
            resolvers.add(new RequestPartArgumentResolver(this.exchangeAdapter));
            resolvers.add(new CookieValueArgumentResolver(service));
            if (this.exchangeAdapter.supportsRequestAttributes()) {
                resolvers.add(new RequestAttributeArgumentResolver());
            }
            resolvers.add(new UrlArgumentResolver());
            resolvers.add(new UriBuilderFactoryArgumentResolver());
            resolvers.add(new HttpMethodArgumentResolver());
            return resolvers;
        }
    }
}

