/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.service.invoker;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class HttpRequestValues {
    private static final MultiValueMap<String, String> EMPTY_COOKIES_MAP = CollectionUtils.toMultiValueMap(Collections.emptyMap());
    @Nullable
    private final HttpMethod httpMethod;
    @Nullable
    private final URI uri;
    @Nullable
    private final UriBuilderFactory uriBuilderFactory;
    @Nullable
    private final String uriTemplate;
    private final Map<String, String> uriVariables;
    private final HttpHeaders headers;
    private final MultiValueMap<String, String> cookies;
    private final Map<String, Object> attributes;
    @Nullable
    private final Object bodyValue;

    protected HttpRequestValues(@Nullable HttpMethod httpMethod, @Nullable URI uri, @Nullable UriBuilderFactory uriBuilderFactory, @Nullable String uriTemplate, Map<String, String> uriVariables, HttpHeaders headers, MultiValueMap<String, String> cookies, Map<String, Object> attributes, @Nullable Object bodyValue) {
        Assert.isTrue(uri != null || uriTemplate != null, "Neither URI nor URI template");
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.uriBuilderFactory = uriBuilderFactory;
        this.uriTemplate = uriTemplate;
        this.uriVariables = uriVariables;
        this.headers = headers;
        this.cookies = cookies;
        this.attributes = attributes;
        this.bodyValue = bodyValue;
    }

    @Nullable
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Nullable
    public URI getUri() {
        return this.uri;
    }

    @Nullable
    public UriBuilderFactory getUriBuilderFactory() {
        return this.uriBuilderFactory;
    }

    @Nullable
    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public Map<String, String> getUriVariables() {
        return this.uriVariables;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, String> getCookies() {
        return this.cookies;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public Object getBodyValue() {
        return this.bodyValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Metadata {
        @Nullable
        private HttpMethod httpMethod;
        @Nullable
        private URI uri;
        @Nullable
        private UriBuilderFactory uriBuilderFactory;
        @Nullable
        private String uriTemplate;
        @Nullable
        private Map<String, String> uriVars;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private MultiValueMap<String, String> cookies;
        @Nullable
        private MultiValueMap<String, String> requestParams;
        @Nullable
        private MultiValueMap<String, Object> parts;
        @Nullable
        private Map<String, Object> attributes;
        @Nullable
        private Object bodyValue;

        public Builder setHttpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder setUriBuilderFactory(@Nullable UriBuilderFactory uriBuilderFactory) {
            this.uriBuilderFactory = uriBuilderFactory;
            return this;
        }

        public Builder setUriTemplate(String uriTemplate) {
            this.uriTemplate = uriTemplate;
            return this;
        }

        public Builder setUriVariable(String name, String value) {
            this.uriVars = this.uriVars != null ? this.uriVars : new LinkedHashMap<String, String>();
            this.uriVars.put(name, value);
            return this;
        }

        public Builder setAccept(List<MediaType> acceptableMediaTypes) {
            this.initHeaders().setAccept(acceptableMediaTypes);
            return this;
        }

        public Builder setContentType(MediaType contentType) {
            this.initHeaders().setContentType(contentType);
            return this;
        }

        public Builder addHeader(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.initHeaders().add(headerName, headerValue);
            }
            return this;
        }

        private HttpHeaders initHeaders() {
            this.headers = this.headers != null ? this.headers : new HttpHeaders();
            return this.headers;
        }

        public Builder addCookie(String name, String ... values2) {
            this.cookies = this.cookies != null ? this.cookies : new LinkedMultiValueMap<String, String>();
            for (String value : values2) {
                this.cookies.add(name, value);
            }
            return this;
        }

        public Builder addRequestParameter(String name, String ... values2) {
            this.requestParams = this.requestParams != null ? this.requestParams : new LinkedMultiValueMap<String, String>();
            for (String value : values2) {
                this.requestParams.add(name, value);
            }
            return this;
        }

        public Builder addRequestPart(String name, Object part) {
            this.parts = this.parts != null ? this.parts : new LinkedMultiValueMap<String, Object>();
            this.parts.add(name, part);
            return this;
        }

        public Builder addAttribute(String name, Object value) {
            this.attributes = this.attributes != null ? this.attributes : new HashMap<String, Object>();
            this.attributes.put(name, value);
            return this;
        }

        public void setBodyValue(@Nullable Object bodyValue) {
            this.bodyValue = bodyValue;
        }

        @Override
        @Nullable
        public HttpMethod getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        @Nullable
        public String getUriTemplate() {
            return this.uriTemplate;
        }

        @Override
        @Nullable
        public MediaType getContentType() {
            return this.headers != null ? this.headers.getContentType() : null;
        }

        @Override
        @Nullable
        public List<MediaType> getAcceptMediaTypes() {
            return this.headers != null ? this.headers.getAccept() : null;
        }

        public HttpRequestValues build() {
            URI uri = this.uri;
            UriBuilderFactory uriBuilderFactory = this.uriBuilderFactory;
            String uriTemplate = this.uriTemplate != null ? this.uriTemplate : "";
            HashMap<String, String> uriVars = this.uriVars != null ? new HashMap<String, String>(this.uriVars) : Collections.emptyMap();
            LinkedMultiValueMap bodyValue = this.bodyValue;
            if (this.hasParts()) {
                Assert.isTrue(!this.hasBody(), "Expected body or request parts, not both");
                bodyValue = this.buildMultipartBody();
            }
            if (!CollectionUtils.isEmpty(this.requestParams)) {
                if (this.hasFormDataContentType()) {
                    Assert.isTrue(!this.hasParts(), "Request parts not expected for a form data request");
                    Assert.isTrue(!this.hasBody(), "Body not expected for a form data request");
                    bodyValue = new LinkedMultiValueMap(this.requestParams);
                } else if (uri != null) {
                    uri = ((UriComponentsBuilder)UriComponentsBuilder.fromUri(uri).queryParams((MultiValueMap)UriUtils.encodeQueryParams(this.requestParams))).build(true).toUri();
                } else {
                    uriVars = uriVars.isEmpty() ? new HashMap<String, String>() : uriVars;
                    uriTemplate = this.appendQueryParams(uriTemplate, uriVars, this.requestParams);
                }
            }
            HttpHeaders headers = HttpHeaders.EMPTY;
            if (this.headers != null) {
                headers = new HttpHeaders();
                headers.putAll(this.headers);
            }
            LinkedMultiValueMap<String, String> cookies = this.cookies != null ? new LinkedMultiValueMap<String, String>(this.cookies) : EMPTY_COOKIES_MAP;
            HashMap<String, Object> attributes = this.attributes != null ? new HashMap<String, Object>(this.attributes) : Collections.emptyMap();
            return this.createRequestValues(this.httpMethod, uri, uriBuilderFactory, uriTemplate, uriVars, headers, cookies, attributes, bodyValue);
        }

        protected boolean hasParts() {
            return this.parts != null;
        }

        protected boolean hasBody() {
            return this.bodyValue != null;
        }

        protected Object buildMultipartBody() {
            Assert.notNull(this.parts, "`parts` is null, was hasParts() not called?");
            return this.parts;
        }

        private boolean hasFormDataContentType() {
            return this.headers != null && MediaType.APPLICATION_FORM_URLENCODED.equals(this.headers.getContentType());
        }

        private String appendQueryParams(String uriTemplate, Map<String, String> uriVars, MultiValueMap<String, String> requestParams) {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString(uriTemplate);
            int i2 = 0;
            for (Map.Entry entry : requestParams.entrySet()) {
                String nameVar = "queryParam" + i2;
                uriVars.put(nameVar, (String)entry.getKey());
                for (int j = 0; j < ((List)entry.getValue()).size(); ++j) {
                    String valueVar = nameVar + "[" + j + "]";
                    uriVars.put(valueVar, (String)((List)entry.getValue()).get(j));
                    uriComponentsBuilder.queryParam("{" + nameVar + "}", "{" + valueVar + "}");
                }
                ++i2;
            }
            return uriComponentsBuilder.build().toUriString();
        }

        protected HttpRequestValues createRequestValues(@Nullable HttpMethod httpMethod, @Nullable URI uri, @Nullable UriBuilderFactory uriBuilderFactory, @Nullable String uriTemplate, Map<String, String> uriVars, HttpHeaders headers, MultiValueMap<String, String> cookies, Map<String, Object> attributes, @Nullable Object bodyValue) {
            return new HttpRequestValues(this.httpMethod, uri, uriBuilderFactory, uriTemplate, uriVars, headers, cookies, attributes, bodyValue);
        }
    }

    public static interface Metadata {
        @Nullable
        public HttpMethod getHttpMethod();

        @Nullable
        public String getUriTemplate();

        @Nullable
        public MediaType getContentType();

        @Nullable
        public List<MediaType> getAcceptMediaTypes();
    }
}

