/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotatedMethod;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ResponseStatus;

public class HandlerMethod
extends AnnotatedMethod {
    protected static final Log logger = LogFactory.getLog(HandlerMethod.class);
    private final Object bean;
    @Nullable
    private final BeanFactory beanFactory;
    @Nullable
    private final MessageSource messageSource;
    private final Class<?> beanType;
    private final boolean validateArguments;
    private final boolean validateReturnValue;
    @Nullable
    private HttpStatusCode responseStatus;
    @Nullable
    private String responseStatusReason;
    @Nullable
    private HandlerMethod resolvedFromHandlerMethod;
    private final String description;

    public HandlerMethod(Object bean2, Method method) {
        this(bean2, method, null);
    }

    protected HandlerMethod(Object bean2, Method method, @Nullable MessageSource messageSource) {
        super(method);
        this.bean = bean2;
        this.beanFactory = null;
        this.messageSource = messageSource;
        this.beanType = ClassUtils.getUserClass(bean2);
        this.validateArguments = false;
        this.validateReturnValue = false;
        this.evaluateResponseStatus();
        this.description = HandlerMethod.initDescription(this.beanType, method);
    }

    public HandlerMethod(Object bean2, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        super(bean2.getClass().getMethod(methodName, parameterTypes));
        this.bean = bean2;
        this.beanFactory = null;
        this.messageSource = null;
        this.beanType = ClassUtils.getUserClass(bean2);
        this.validateArguments = false;
        this.validateReturnValue = false;
        this.evaluateResponseStatus();
        this.description = HandlerMethod.initDescription(this.beanType, this.getMethod());
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, Method method) {
        this(beanName, beanFactory, null, method);
    }

    public HandlerMethod(String beanName, BeanFactory beanFactory, @Nullable MessageSource messageSource, Method method) {
        super(method);
        Assert.hasText(beanName, "Bean name is required");
        Assert.notNull((Object)beanFactory, "BeanFactory is required");
        this.bean = beanName;
        this.beanFactory = beanFactory;
        this.messageSource = messageSource;
        Class<?> beanType = beanFactory.getType(beanName);
        if (beanType == null) {
            throw new IllegalStateException("Cannot resolve bean type for bean with name '" + beanName + "'");
        }
        this.beanType = ClassUtils.getUserClass(beanType);
        this.validateArguments = false;
        this.validateReturnValue = false;
        this.evaluateResponseStatus();
        this.description = HandlerMethod.initDescription(this.beanType, method);
    }

    protected HandlerMethod(HandlerMethod handlerMethod) {
        this(handlerMethod, null, false);
    }

    private HandlerMethod(HandlerMethod handlerMethod, @Nullable Object handler, boolean initValidateFlags) {
        super(handlerMethod);
        this.bean = handler != null ? handler : handlerMethod.bean;
        this.beanFactory = handlerMethod.beanFactory;
        this.messageSource = handlerMethod.messageSource;
        this.beanType = handlerMethod.beanType;
        this.validateArguments = initValidateFlags ? MethodValidationInitializer.checkArguments(this.beanType, this.getMethodParameters()) : handlerMethod.validateArguments;
        this.validateReturnValue = initValidateFlags ? MethodValidationInitializer.checkReturnValue(this.beanType, this.getBridgedMethod()) : handlerMethod.validateReturnValue;
        this.responseStatus = handlerMethod.responseStatus;
        this.responseStatusReason = handlerMethod.responseStatusReason;
        this.resolvedFromHandlerMethod = handlerMethod;
        this.description = handlerMethod.toString();
    }

    private void evaluateResponseStatus() {
        ResponseStatus annotation = this.getMethodAnnotation(ResponseStatus.class);
        if (annotation == null) {
            annotation = AnnotatedElementUtils.findMergedAnnotation(this.getBeanType(), ResponseStatus.class);
        }
        if (annotation != null) {
            String reason = annotation.reason();
            String resolvedReason = StringUtils.hasText(reason) && this.messageSource != null ? this.messageSource.getMessage(reason, null, reason, LocaleContextHolder.getLocale()) : reason;
            this.responseStatus = annotation.code();
            this.responseStatusReason = resolvedReason;
            if (StringUtils.hasText(this.responseStatusReason) && this.getMethod().getReturnType() != Void.TYPE) {
                logger.warn("Return value of [" + this.getMethod() + "] will be ignored since @ResponseStatus 'reason' attribute is set.");
            }
        }
    }

    private static String initDescription(Class<?> beanType, Method method) {
        StringJoiner joiner = new StringJoiner(", ", "(", ")");
        for (Class<?> paramType : method.getParameterTypes()) {
            joiner.add(paramType.getSimpleName());
        }
        return beanType.getName() + "#" + method.getName() + joiner;
    }

    public Object getBean() {
        return this.bean;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    @Override
    protected Class<?> getContainingClass() {
        return this.beanType;
    }

    public boolean shouldValidateArguments() {
        return this.validateArguments;
    }

    public boolean shouldValidateReturnValue() {
        return this.validateReturnValue;
    }

    @Nullable
    protected HttpStatusCode getResponseStatus() {
        return this.responseStatus;
    }

    @Nullable
    protected String getResponseStatusReason() {
        return this.responseStatusReason;
    }

    @Nullable
    public HandlerMethod getResolvedFromHandlerMethod() {
        return this.resolvedFromHandlerMethod;
    }

    public HandlerMethod createWithValidateFlags() {
        return new HandlerMethod(this, null, true);
    }

    public HandlerMethod createWithResolvedBean() {
        Object handler = this.bean;
        Object object = this.bean;
        if (object instanceof String) {
            String beanName = (String)object;
            Assert.state(this.beanFactory != null, "Cannot resolve bean name without BeanFactory");
            handler = this.beanFactory.getBean(beanName);
        }
        Assert.notNull(handler, "No handler instance");
        return new HandlerMethod(this, handler, false);
    }

    public String getShortLogMessage() {
        return this.getBeanType().getName() + "#" + this.getMethod().getName() + "[" + this.getMethod().getParameterCount() + " args]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!super.equals(other)) return false;
        if (!(other instanceof HandlerMethod)) return false;
        HandlerMethod otherMethod = (HandlerMethod)other;
        if (!this.bean.equals(otherMethod.bean)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.bean.hashCode() * 31 + super.hashCode();
    }

    @Override
    public String toString() {
        return this.description;
    }

    protected void assertTargetBean(Method method, Object targetBean, Object[] args2) {
        Class<?> targetBeanClass;
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        if (!methodDeclaringClass.isAssignableFrom(targetBeanClass = targetBean.getClass())) {
            String text = "The mapped handler method class '" + methodDeclaringClass.getName() + "' is not an instance of the actual controller bean class '" + targetBeanClass.getName() + "'. If the controller requires proxying (for example, due to @Transactional), please use class-based proxying.";
            throw new IllegalStateException(this.formatInvokeError(text, args2));
        }
    }

    protected String formatInvokeError(String text, Object[] args2) {
        String formattedArgs = IntStream.range(0, args2.length).mapToObj(i2 -> args2[i2] != null ? "[" + i2 + "] [type=" + args2[i2].getClass().getName() + "] [value=" + args2[i2] + "]" : "[" + i2 + "] [null]").collect(Collectors.joining(",\n", " ", " "));
        return text + "\nController [" + this.getBeanType().getName() + "]\nMethod [" + this.getBridgedMethod().toGenericString() + "] with argument values:\n" + formattedArgs;
    }

    private static class MethodValidationInitializer {
        private static final boolean BEAN_VALIDATION_PRESENT = ClassUtils.isPresent("jakarta.validation.Validator", HandlerMethod.class.getClassLoader());
        private static final Predicate<MergedAnnotation<? extends Annotation>> CONSTRAINT_PREDICATE = MergedAnnotationPredicates.typeIn("jakarta.validation.Constraint");
        private static final Predicate<MergedAnnotation<? extends Annotation>> VALID_PREDICATE = MergedAnnotationPredicates.typeIn("jakarta.validation.Valid");

        private MethodValidationInitializer() {
        }

        public static boolean checkArguments(Class<?> beanType, MethodParameter[] parameters) {
            if (BEAN_VALIDATION_PRESENT && AnnotationUtils.findAnnotation(beanType, Validated.class) == null) {
                for (MethodParameter param : parameters) {
                    MergedAnnotations merged = MergedAnnotations.from(param.getParameterAnnotations());
                    if (merged.stream().anyMatch(CONSTRAINT_PREDICATE)) {
                        return true;
                    }
                    Class<?> type = param.getParameterType();
                    if (merged.stream().anyMatch(VALID_PREDICATE) && MethodValidationInitializer.isIndexOrKeyBasedContainer(type)) {
                        return true;
                    }
                    merged = MergedAnnotations.from(MethodValidationInitializer.getContainerElementAnnotations(param));
                    if (!merged.stream().anyMatch(CONSTRAINT_PREDICATE.or(VALID_PREDICATE))) continue;
                    return true;
                }
            }
            return false;
        }

        public static boolean checkReturnValue(Class<?> beanType, Method method) {
            if (BEAN_VALIDATION_PRESENT && AnnotationUtils.findAnnotation(beanType, Validated.class) == null) {
                MergedAnnotations merged = MergedAnnotations.from(method, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
                return merged.stream().anyMatch(CONSTRAINT_PREDICATE.or(VALID_PREDICATE));
            }
            return false;
        }

        private static boolean isIndexOrKeyBasedContainer(Class<?> type) {
            return List.class.isAssignableFrom(type) || Object[].class.isAssignableFrom(type) || Map.class.isAssignableFrom(type);
        }

        private static Annotation[] getContainerElementAnnotations(MethodParameter param) {
            AnnotatedType[] annotatedTypeArray;
            ArrayList<Annotation> result = null;
            int i2 = param.getParameterIndex();
            Method method = param.getMethod();
            if (method != null && (annotatedTypeArray = method.getAnnotatedParameterTypes()[i2]) instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType apt = (AnnotatedParameterizedType)annotatedTypeArray;
                for (AnnotatedType type : apt.getAnnotatedActualTypeArguments()) {
                    for (Annotation annot : type.getAnnotations()) {
                        result = result != null ? result : new ArrayList<Annotation>();
                        result.add(annot);
                    }
                }
            }
            result = result != null ? result : Collections.emptyList();
            return result.toArray(new Annotation[0]);
        }
    }
}

