/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.support;

import java.net.URI;
import java.util.ArrayList;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.client.RestClient;
import org.springframework.web.service.invoker.HttpExchangeAdapter;
import org.springframework.web.service.invoker.HttpRequestValues;
import org.springframework.web.util.UriBuilderFactory;

public final class RestClientAdapter
implements HttpExchangeAdapter {
    private final RestClient restClient;

    private RestClientAdapter(RestClient restClient) {
        this.restClient = restClient;
    }

    @Override
    public boolean supportsRequestAttributes() {
        return true;
    }

    @Override
    public void exchange(HttpRequestValues requestValues) {
        this.newRequest(requestValues).retrieve().toBodilessEntity();
    }

    @Override
    public HttpHeaders exchangeForHeaders(HttpRequestValues values2) {
        return this.newRequest(values2).retrieve().toBodilessEntity().getHeaders();
    }

    @Override
    @Nullable
    public <T> T exchangeForBody(HttpRequestValues values2, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(values2).retrieve().body(bodyType);
    }

    @Override
    public ResponseEntity<Void> exchangeForBodilessEntity(HttpRequestValues values2) {
        return this.newRequest(values2).retrieve().toBodilessEntity();
    }

    @Override
    public <T> ResponseEntity<T> exchangeForEntity(HttpRequestValues values2, ParameterizedTypeReference<T> bodyType) {
        return this.newRequest(values2).retrieve().toEntity(bodyType);
    }

    private RestClient.RequestBodySpec newRequest(HttpRequestValues values2) {
        RestClient.RequestBodySpec bodySpec;
        HttpMethod httpMethod = values2.getHttpMethod();
        Assert.notNull((Object)httpMethod, "HttpMethod is required");
        RestClient.RequestBodyUriSpec uriSpec = this.restClient.method(httpMethod);
        if (values2.getUri() != null) {
            bodySpec = (RestClient.RequestBodySpec)uriSpec.uri(values2.getUri());
        } else if (values2.getUriTemplate() != null) {
            UriBuilderFactory uriBuilderFactory = values2.getUriBuilderFactory();
            if (uriBuilderFactory != null) {
                URI uri = uriBuilderFactory.expand(values2.getUriTemplate(), values2.getUriVariables());
                bodySpec = (RestClient.RequestBodySpec)uriSpec.uri(uri);
            } else {
                bodySpec = (RestClient.RequestBodySpec)uriSpec.uri(values2.getUriTemplate(), values2.getUriVariables());
            }
        } else {
            throw new IllegalStateException("Neither full URL nor URI template");
        }
        bodySpec.headers(headers -> headers.putAll(values2.getHeaders()));
        if (!values2.getCookies().isEmpty()) {
            ArrayList cookies = new ArrayList();
            values2.getCookies().forEach((name, cookieValues) -> cookieValues.forEach(value -> {
                HttpCookie cookie = new HttpCookie((String)name, (String)value);
                cookies.add(cookie.toString());
            }));
            bodySpec.header("Cookie", String.join((CharSequence)"; ", cookies));
        }
        bodySpec.attributes(attributes -> attributes.putAll(values2.getAttributes()));
        if (values2.getBodyValue() != null) {
            bodySpec.body(values2.getBodyValue());
        }
        return bodySpec;
    }

    public static RestClientAdapter create(RestClient restClient) {
        return new RestClientAdapter(restClient);
    }
}

