/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ResolvableType;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.SmartHttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.IntrospectingClientHttpResponse;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.UnknownContentTypeException;

public class HttpMessageConverterExtractor<T>
implements ResponseExtractor<T> {
    private final Type responseType;
    @Nullable
    private final Class<T> responseClass;
    private final List<HttpMessageConverter<?>> messageConverters;
    private final Log logger;

    public HttpMessageConverterExtractor(Class<T> responseType, List<HttpMessageConverter<?>> messageConverters) {
        this((Type)responseType, messageConverters);
    }

    public HttpMessageConverterExtractor(Type responseType, List<HttpMessageConverter<?>> messageConverters) {
        this(responseType, messageConverters, LogFactory.getLog(HttpMessageConverterExtractor.class));
    }

    HttpMessageConverterExtractor(Type responseType, List<HttpMessageConverter<?>> messageConverters, Log logger) {
        Class clazz;
        Assert.notNull((Object)responseType, "'responseType' must not be null");
        Assert.notEmpty(messageConverters, "'messageConverters' must not be empty");
        Assert.noNullElements(messageConverters, "'messageConverters' must not contain null elements");
        this.responseType = responseType;
        this.responseClass = responseType instanceof Class ? (clazz = (Class)responseType) : null;
        this.messageConverters = messageConverters;
        this.logger = logger;
    }

    @Override
    @Nullable
    public T extractData(ClientHttpResponse response) throws IOException {
        IntrospectingClientHttpResponse responseWrapper = new IntrospectingClientHttpResponse(response);
        if (!responseWrapper.hasMessageBody() || responseWrapper.hasEmptyMessageBody()) {
            return null;
        }
        MediaType contentType = this.getContentType(responseWrapper);
        try {
            for (HttpMessageConverter<T> httpMessageConverter : this.messageConverters) {
                ResolvableType resolvableType;
                if (httpMessageConverter instanceof GenericHttpMessageConverter) {
                    GenericHttpMessageConverter genericMessageConverter = (GenericHttpMessageConverter)httpMessageConverter;
                    if (!genericMessageConverter.canRead(this.responseType, null, contentType)) continue;
                    if (this.logger.isDebugEnabled()) {
                        resolvableType = ResolvableType.forType(this.responseType);
                        this.logger.debug("Reading to [" + resolvableType + "]");
                    }
                    return genericMessageConverter.read(this.responseType, null, responseWrapper);
                }
                if (httpMessageConverter instanceof SmartHttpMessageConverter) {
                    SmartHttpMessageConverter smartMessageConverter = (SmartHttpMessageConverter)httpMessageConverter;
                    resolvableType = ResolvableType.forType(this.responseType);
                    if (!smartMessageConverter.canRead(resolvableType, contentType)) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Reading to [" + resolvableType + "]");
                    }
                    return smartMessageConverter.read(resolvableType, responseWrapper, null);
                }
                if (this.responseClass == null || !httpMessageConverter.canRead(this.responseClass, contentType)) continue;
                if (this.logger.isDebugEnabled()) {
                    String className = this.responseClass.getName();
                    this.logger.debug("Reading to [" + className + "] as \"" + contentType + "\"");
                }
                return (T)httpMessageConverter.read(this.responseClass, responseWrapper);
            }
        }
        catch (IOException | HttpMessageNotReadableException ex) {
            throw new RestClientException("Error while extracting response for type [" + this.responseType + "] and content type [" + contentType + "]", ex);
        }
        throw new UnknownContentTypeException(this.responseType, contentType, responseWrapper.getStatusCode(), responseWrapper.getStatusText(), responseWrapper.getHeaders(), HttpMessageConverterExtractor.getResponseBody(responseWrapper));
    }

    protected MediaType getContentType(ClientHttpResponse response) {
        MediaType contentType = response.getHeaders().getContentType();
        if (contentType == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No content-type, using 'application/octet-stream'");
            }
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        return contentType;
    }

    private static byte[] getResponseBody(ClientHttpResponse response) {
        try {
            return FileCopyUtils.copyToByteArray(response.getBody());
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }
}

