/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class PlaceholderResolutionException
extends IllegalArgumentException {
    private final String reason;
    private final String placeholder;
    private final List<String> values;

    PlaceholderResolutionException(String reason, String placeholder, @Nullable String value) {
        this(reason, placeholder, value != null ? List.of(value) : Collections.emptyList());
    }

    private PlaceholderResolutionException(String reason, String placeholder, List<String> values2) {
        super(PlaceholderResolutionException.buildMessage(reason, values2));
        this.reason = reason;
        this.placeholder = placeholder;
        this.values = values2;
    }

    private static String buildMessage(String reason, List<String> values2) {
        StringBuilder sb = new StringBuilder();
        sb.append(reason);
        if (!CollectionUtils.isEmpty(values2)) {
            String valuesChain = values2.stream().map(value -> "\"" + value + "\"").collect(Collectors.joining(" <-- "));
            sb.append(" in value %s".formatted(valuesChain));
        }
        return sb.toString();
    }

    PlaceholderResolutionException withValue(String value) {
        ArrayList<String> allValues = new ArrayList<String>(this.values);
        allValues.add(value);
        return new PlaceholderResolutionException(this.reason, this.placeholder, allValues);
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public List<String> getValues() {
        return this.values;
    }
}

