/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.PlaceholderResolutionException;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.util.StringUtils;

final class PlaceholderParser {
    private static final Log logger = LogFactory.getLog(PlaceholderParser.class);
    private static final Map<String, String> wellKnownSimplePrefixes = Map.of("}", "{", "]", "[", ")", "(");
    private final String prefix;
    private final String suffix;
    private final String simplePrefix;
    @Nullable
    private final String separator;
    private final boolean ignoreUnresolvablePlaceholders;
    @Nullable
    private final Character escape;

    PlaceholderParser(String prefix, String suffix, @Nullable String separator, @Nullable Character escape, boolean ignoreUnresolvablePlaceholders) {
        this.prefix = prefix;
        this.suffix = suffix;
        String simplePrefixForSuffix = wellKnownSimplePrefixes.get(this.suffix);
        this.simplePrefix = simplePrefixForSuffix != null && this.prefix.endsWith(simplePrefixForSuffix) ? simplePrefixForSuffix : this.prefix;
        this.separator = separator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
        this.escape = escape;
    }

    public String replacePlaceholders(String value, PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) {
        Assert.notNull((Object)value, "'value' must not be null");
        ParsedValue parsedValue = this.parse(value);
        PartResolutionContext resolutionContext = new PartResolutionContext(placeholderResolver, this.prefix, this.suffix, this.ignoreUnresolvablePlaceholders, candidate -> this.parse((String)candidate, false));
        return parsedValue.resolve(resolutionContext);
    }

    ParsedValue parse(String value) {
        List<Part> parts = this.parse(value, false);
        return new ParsedValue(value, parts);
    }

    private List<Part> parse(String value, boolean inPlaceholder) {
        LinkedList<Part> parts = new LinkedList<Part>();
        int startIndex = this.nextStartPrefix(value, 0);
        if (startIndex == -1) {
            Record part = inPlaceholder ? this.createSimplePlaceholderPart(value) : new TextPart(value);
            parts.add((Part)((Object)part));
            return parts;
        }
        int position = 0;
        while (startIndex != -1) {
            int endIndex = this.nextValidEndPrefix(value, startIndex);
            if (endIndex == -1) {
                PlaceholderParser.addText(value, position, startIndex + this.prefix.length(), parts);
                position = startIndex + this.prefix.length();
                startIndex = this.nextStartPrefix(value, position);
                continue;
            }
            if (this.isEscaped(value, startIndex)) {
                PlaceholderParser.addText(value, position, startIndex - 1, parts);
                PlaceholderParser.addText(value, startIndex, startIndex + this.prefix.length(), parts);
                position = startIndex + this.prefix.length();
                startIndex = this.nextStartPrefix(value, position);
                continue;
            }
            PlaceholderParser.addText(value, position, startIndex, parts);
            String placeholder = value.substring(startIndex + this.prefix.length(), endIndex);
            List<Part> placeholderParts = this.parse(placeholder, true);
            parts.addAll(placeholderParts);
            startIndex = this.nextStartPrefix(value, endIndex + this.suffix.length());
            position = endIndex + this.suffix.length();
        }
        PlaceholderParser.addText(value, position, value.length(), parts);
        return inPlaceholder ? List.of(this.createNestedPlaceholderPart(value, parts)) : parts;
    }

    private SimplePlaceholderPart createSimplePlaceholderPart(String text) {
        String[] keyAndDefault = this.splitKeyAndDefault(text);
        return keyAndDefault != null ? new SimplePlaceholderPart(text, keyAndDefault[0], keyAndDefault[1]) : new SimplePlaceholderPart(text, text, null);
    }

    private NestedPlaceholderPart createNestedPlaceholderPart(String text, List<Part> parts) {
        if (this.separator == null) {
            return new NestedPlaceholderPart(text, parts, null);
        }
        ArrayList<Part> keyParts = new ArrayList<Part>();
        ArrayList<Part> defaultParts = new ArrayList<Part>();
        for (int i2 = 0; i2 < parts.size(); ++i2) {
            Part part = parts.get(i2);
            if (!(part instanceof TextPart)) {
                keyParts.add(part);
                continue;
            }
            String candidate = part.text();
            String[] keyAndDefault = this.splitKeyAndDefault(candidate);
            if (keyAndDefault != null) {
                keyParts.add(new TextPart(keyAndDefault[0]));
                if (keyAndDefault[1] != null) {
                    defaultParts.add(new TextPart(keyAndDefault[1]));
                }
                defaultParts.addAll(parts.subList(i2 + 1, parts.size()));
                return new NestedPlaceholderPart(text, keyParts, defaultParts);
            }
            keyParts.add(part);
        }
        return new NestedPlaceholderPart(text, parts, null);
    }

    @Nullable
    private String[] splitKeyAndDefault(String value) {
        if (this.separator == null || !value.contains(this.separator)) {
            return null;
        }
        int position = 0;
        int index = value.indexOf(this.separator, position);
        StringBuilder buffer = new StringBuilder();
        while (index != -1) {
            if (this.isEscaped(value, index)) {
                buffer.append(value, position, index - 1);
                buffer.append(value, index, index + this.separator.length());
                position = index + this.separator.length();
                index = value.indexOf(this.separator, position);
                continue;
            }
            buffer.append(value, position, index);
            String key = buffer.toString();
            String fallback = value.substring(index + this.separator.length());
            return new String[]{key, fallback};
        }
        buffer.append(value, position, value.length());
        return new String[]{buffer.toString(), null};
    }

    private static void addText(String value, int start2, int end, LinkedList<Part> parts) {
        if (start2 > end) {
            return;
        }
        String text = value.substring(start2, end);
        if (!text.isEmpty()) {
            if (!parts.isEmpty()) {
                Part current = parts.removeLast();
                if (current instanceof TextPart) {
                    TextPart textPart = (TextPart)current;
                    parts.add(new TextPart(textPart.text + text));
                } else {
                    parts.add(current);
                    parts.add(new TextPart(text));
                }
            } else {
                parts.add(new TextPart(text));
            }
        }
    }

    private int nextStartPrefix(String value, int index) {
        return value.indexOf(this.prefix, index);
    }

    private int nextValidEndPrefix(String value, int startIndex) {
        int index = startIndex + this.prefix.length();
        int withinNestedPlaceholder = 0;
        while (index < value.length()) {
            if (StringUtils.substringMatch(value, index, this.suffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.suffix.length();
                    continue;
                }
                return index;
            }
            if (StringUtils.substringMatch(value, index, this.simplePrefix)) {
                ++withinNestedPlaceholder;
                index += this.simplePrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    private boolean isEscaped(String value, int index) {
        return this.escape != null && index > 0 && value.charAt(index - 1) == this.escape.charValue();
    }

    record ParsedValue(String text, List<Part> parts) {
        public String resolve(PartResolutionContext resolutionContext) {
            try {
                return Part.resolveAll(this.parts, resolutionContext);
            }
            catch (PlaceholderResolutionException ex) {
                throw ex.withValue(this.text);
            }
        }
    }

    static class PartResolutionContext
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String prefix;
        private final String suffix;
        private final boolean ignoreUnresolvablePlaceholders;
        private final Function<String, List<Part>> parser;
        private final PropertyPlaceholderHelper.PlaceholderResolver resolver;
        @Nullable
        private Set<String> visitedPlaceholders;

        PartResolutionContext(PropertyPlaceholderHelper.PlaceholderResolver resolver, String prefix, String suffix, boolean ignoreUnresolvablePlaceholders, Function<String, List<Part>> parser) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
            this.parser = parser;
            this.resolver = resolver;
        }

        @Override
        @Nullable
        public String resolvePlaceholder(String placeholderName) {
            String value = this.resolver.resolvePlaceholder(placeholderName);
            if (value != null && logger.isTraceEnabled()) {
                logger.trace("Resolved placeholder '" + placeholderName + "'");
            }
            return value;
        }

        public String handleUnresolvablePlaceholder(String key, String text) {
            if (this.ignoreUnresolvablePlaceholders) {
                return this.toPlaceholderText(key);
            }
            String originalValue = !key.equals(text) ? this.toPlaceholderText(text) : null;
            throw new PlaceholderResolutionException("Could not resolve placeholder '%s'".formatted(key), key, originalValue);
        }

        private String toPlaceholderText(String text) {
            return this.prefix + text + this.suffix;
        }

        public List<Part> parse(String text) {
            return this.parser.apply(text);
        }

        public void flagPlaceholderAsVisited(String placeholder) {
            if (this.visitedPlaceholders == null) {
                this.visitedPlaceholders = new HashSet<String>(4);
            }
            if (!this.visitedPlaceholders.add(placeholder)) {
                throw new PlaceholderResolutionException("Circular placeholder reference '%s'".formatted(placeholder), placeholder, null);
            }
        }

        public void removePlaceholder(String placeholder) {
            Assert.state(this.visitedPlaceholders != null, "Visited placeholders must not be null");
            this.visitedPlaceholders.remove(placeholder);
        }
    }

    record SimplePlaceholderPart(String text, String key, @Nullable String fallback) implements Part
    {
        @Override
        public String resolve(PartResolutionContext resolutionContext) {
            String resolvedValue = this.resolveToText(resolutionContext, this.key);
            if (resolvedValue != null) {
                return resolvedValue;
            }
            if (this.fallback != null) {
                return this.fallback;
            }
            return resolutionContext.handleUnresolvablePlaceholder(this.key, this.text);
        }

        @Nullable
        private String resolveToText(PartResolutionContext resolutionContext, String text) {
            String resolvedValue = resolutionContext.resolvePlaceholder(text);
            if (resolvedValue != null) {
                resolutionContext.flagPlaceholderAsVisited(text);
                List<Part> nestedParts = resolutionContext.parse(resolvedValue);
                String value = this.toText(nestedParts);
                if (!this.isTextOnly(nestedParts)) {
                    value = new ParsedValue(resolvedValue, nestedParts).resolve(resolutionContext);
                }
                resolutionContext.removePlaceholder(text);
                return value;
            }
            return null;
        }

        private boolean isTextOnly(List<Part> parts) {
            return parts.stream().allMatch(TextPart.class::isInstance);
        }

        private String toText(List<Part> parts) {
            StringBuilder sb = new StringBuilder();
            parts.forEach(part -> sb.append(part.text()));
            return sb.toString();
        }
    }

    record TextPart(String text) implements Part
    {
        @Override
        public String resolve(PartResolutionContext resolutionContext) {
            return this.text;
        }
    }

    record NestedPlaceholderPart(String text, List<Part> keyParts, @Nullable List<Part> defaultParts) implements Part
    {
        @Override
        public String resolve(PartResolutionContext resolutionContext) {
            String resolvedKey = Part.resolveAll(this.keyParts, resolutionContext);
            String value = resolutionContext.resolvePlaceholder(resolvedKey);
            if (value != null) {
                return value;
            }
            if (this.defaultParts != null) {
                return Part.resolveAll(this.defaultParts, resolutionContext);
            }
            return resolutionContext.handleUnresolvablePlaceholder(resolvedKey, this.text);
        }
    }

    static interface Part {
        public String resolve(PartResolutionContext var1);

        public String text();

        public static String resolveAll(Iterable<Part> parts, PartResolutionContext resolutionContext) {
            StringBuilder sb = new StringBuilder();
            for (Part part : parts) {
                sb.append(part.resolve(resolutionContext));
            }
            return sb.toString();
        }
    }
}

