/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.lang.Contract;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Assert {
    @Contract(value="false, _ -> fail")
    public static void state(boolean expression, String message2) {
        if (!expression) {
            throw new IllegalStateException(message2);
        }
    }

    @Contract(value="false, _ -> fail")
    public static void state(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalStateException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Contract(value="false, _ -> fail")
    public static void isTrue(boolean expression, String message2) {
        if (!expression) {
            throw new IllegalArgumentException(message2);
        }
    }

    @Contract(value="false, _ -> fail")
    public static void isTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Contract(value="!null, _ -> fail")
    public static void isNull(@Nullable Object object, String message2) {
        if (object != null) {
            throw new IllegalArgumentException(message2);
        }
    }

    @Contract(value="!null, _ -> fail")
    public static void isNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object != null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notNull(@Nullable Object object, String message2) {
        if (object == null) {
            throw new IllegalArgumentException(message2);
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Contract(value="null, _ -> fail")
    public static void hasLength(@Nullable String text, String message2) {
        if (!StringUtils.hasLength(text)) {
            throw new IllegalArgumentException(message2);
        }
    }

    @Contract(value="null, _ -> fail")
    public static void hasLength(@Nullable String text, Supplier<String> messageSupplier) {
        if (!StringUtils.hasLength(text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Contract(value="null, _ -> fail")
    public static void hasText(@Nullable String text, String message2) {
        if (!StringUtils.hasText(text)) {
            throw new IllegalArgumentException(message2);
        }
    }

    @Contract(value="null, _ -> fail")
    public static void hasText(@Nullable String text, Supplier<String> messageSupplier) {
        if (!StringUtils.hasText(text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, String message2) {
        if (StringUtils.hasLength(textToSearch) && StringUtils.hasLength(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, Supplier<String> messageSupplier) {
        if (StringUtils.hasLength(textToSearch) && StringUtils.hasLength(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(@Nullable Object[] array, String message2) {
        if (ObjectUtils.isEmpty(array)) {
            throw new IllegalArgumentException(message2);
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(@Nullable Object[] array, Supplier<String> messageSupplier) {
        if (ObjectUtils.isEmpty(array)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void noNullElements(@Nullable Object[] array, String message2) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(message2);
            }
        }
    }

    public static void noNullElements(@Nullable Object[] array, Supplier<String> messageSupplier) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
            }
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(@Nullable Collection<?> collection, String message2) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(message2);
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(@Nullable Collection<?> collection, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, String message2) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw new IllegalArgumentException(message2);
            }
        }
    }

    public static void noNullElements(@Nullable Collection<?> collection, Supplier<String> messageSupplier) {
        if (collection != null) {
            for (Object element : collection) {
                if (element != null) continue;
                throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
            }
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(@Nullable Map<?, ?> map, String message2) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException(message2);
        }
    }

    @Contract(value="null, _ -> fail")
    public static void notEmpty(@Nullable Map<?, ?> map, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(map)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Contract(value="_, null, _ -> fail")
    public static void isInstanceOf(Class<?> type, @Nullable Object obj, String message2) {
        Assert.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            Assert.instanceCheckFailed(type, obj, message2);
        }
    }

    @Contract(value="_, null, _ -> fail")
    public static void isInstanceOf(Class<?> type, @Nullable Object obj, Supplier<String> messageSupplier) {
        Assert.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            Assert.instanceCheckFailed(type, obj, Assert.nullSafeGet(messageSupplier));
        }
    }

    @Contract(value="_, null -> fail")
    public static void isInstanceOf(Class<?> type, @Nullable Object obj) {
        Assert.isInstanceOf(type, obj, "");
    }

    @Contract(value="_, null, _ -> fail")
    public static void isAssignable(Class<?> superType, @Nullable Class<?> subType, String message2) {
        Assert.notNull(superType, "Supertype to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Assert.assignableCheckFailed(superType, subType, message2);
        }
    }

    @Contract(value="_, null, _ -> fail")
    public static void isAssignable(Class<?> superType, @Nullable Class<?> subType, Supplier<String> messageSupplier) {
        Assert.notNull(superType, "Supertype to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Assert.assignableCheckFailed(superType, subType, Assert.nullSafeGet(messageSupplier));
        }
    }

    @Contract(value="_, null -> fail")
    public static void isAssignable(Class<?> superType, @Nullable Class<?> subType) {
        Assert.isAssignable(superType, subType, "");
    }

    private static void instanceCheckFailed(Class<?> type, @Nullable Object obj, @Nullable String msg) {
        String className = obj != null ? obj.getClass().getName() : "null";
        Object result = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength(msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = Assert.messageWithTypeName(msg, className);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = (String)result + "Object of class [" + className + "] must be an instance of " + type;
        }
        throw new IllegalArgumentException((String)result);
    }

    private static void assignableCheckFailed(Class<?> superType, @Nullable Class<?> subType, @Nullable String msg) {
        Object result = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength(msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = Assert.messageWithTypeName(msg, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = (String)result + subType + " is not assignable to " + superType;
        }
        throw new IllegalArgumentException((String)result);
    }

    private static boolean endsWithSeparator(String msg) {
        return msg.endsWith(":") || msg.endsWith(";") || msg.endsWith(",") || msg.endsWith(".");
    }

    private static String messageWithTypeName(String msg, @Nullable Object typeName) {
        return msg + (msg.endsWith(" ") ? "" : ": ") + typeName;
    }

    @Nullable
    private static String nullSafeGet(@Nullable Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }
}

