/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.SimpleTriggerContext;

public class NoOpTaskScheduler
implements TaskScheduler {
    @Override
    @Nullable
    public ScheduledFuture<?> schedule(Runnable task2, Trigger trigger) {
        Instant nextExecution = trigger.nextExecution(new SimpleTriggerContext(this.getClock()));
        return nextExecution != null ? new NoOpScheduledFuture() : null;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task2, Instant startTime) {
        return new NoOpScheduledFuture();
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task2, Instant startTime, Duration period) {
        return new NoOpScheduledFuture();
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task2, Duration period) {
        return new NoOpScheduledFuture();
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task2, Instant startTime, Duration delay) {
        return new NoOpScheduledFuture();
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task2, Duration delay) {
        return new NoOpScheduledFuture();
    }

    private static class NoOpScheduledFuture<V>
    implements ScheduledFuture<V> {
        private NoOpScheduledFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return true;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() {
            throw new CancellationException("No-op");
        }

        @Override
        public V get(long timeout, TimeUnit unit) {
            throw new CancellationException("No-op");
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed other) {
            return 0;
        }
    }
}

