/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.DelegatingErrorHandlingCallable;
import org.springframework.scheduling.concurrent.ExecutorConfigurationSupport;
import org.springframework.scheduling.concurrent.ReschedulingRunnable;
import org.springframework.scheduling.support.TaskUtils;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ErrorHandler;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureTask;

public class ThreadPoolTaskScheduler
extends ExecutorConfigurationSupport
implements AsyncListenableTaskExecutor,
SchedulingTaskExecutor,
TaskScheduler {
    private static final TimeUnit NANO = TimeUnit.NANOSECONDS;
    private volatile int poolSize = 1;
    private volatile boolean removeOnCancelPolicy;
    private volatile boolean continueExistingPeriodicTasksAfterShutdownPolicy;
    private volatile boolean executeExistingDelayedTasksAfterShutdownPolicy = true;
    @Nullable
    private TaskDecorator taskDecorator;
    @Nullable
    private volatile ErrorHandler errorHandler;
    private Clock clock = Clock.systemDefaultZone();
    @Nullable
    private ScheduledExecutorService scheduledExecutor;
    private final Map<Object, ListenableFuture<?>> listenableFutureMap = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    public void setPoolSize(int poolSize) {
        Assert.isTrue(poolSize > 0, "'poolSize' must be 1 or higher");
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            threadPoolExecutor.setCorePoolSize(poolSize);
        }
        this.poolSize = poolSize;
    }

    public void setRemoveOnCancelPolicy(boolean flag) {
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            threadPoolExecutor.setRemoveOnCancelPolicy(flag);
        }
        this.removeOnCancelPolicy = flag;
    }

    public void setContinueExistingPeriodicTasksAfterShutdownPolicy(boolean flag) {
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            threadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(flag);
        }
        this.continueExistingPeriodicTasksAfterShutdownPolicy = flag;
    }

    public void setExecuteExistingDelayedTasksAfterShutdownPolicy(boolean flag) {
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            threadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(flag);
        }
        this.executeExistingDelayedTasksAfterShutdownPolicy = flag;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, "Clock must not be null");
        this.clock = clock;
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    @Override
    protected ExecutorService initializeExecutor(ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        this.scheduledExecutor = this.createExecutor(this.poolSize, threadFactory, rejectedExecutionHandler);
        ScheduledExecutorService scheduledExecutorService = this.scheduledExecutor;
        if (scheduledExecutorService instanceof ScheduledThreadPoolExecutor) {
            ScheduledThreadPoolExecutor threadPoolExecutor = (ScheduledThreadPoolExecutor)scheduledExecutorService;
            if (this.removeOnCancelPolicy) {
                threadPoolExecutor.setRemoveOnCancelPolicy(true);
            }
            if (this.continueExistingPeriodicTasksAfterShutdownPolicy) {
                threadPoolExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(true);
            }
            if (!this.executeExistingDelayedTasksAfterShutdownPolicy) {
                threadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            }
        }
        return this.scheduledExecutor;
    }

    protected ScheduledExecutorService createExecutor(int poolSize, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return new ScheduledThreadPoolExecutor(poolSize, threadFactory, rejectedExecutionHandler){

            @Override
            protected void beforeExecute(Thread thread2, Runnable task2) {
                ThreadPoolTaskScheduler.this.beforeExecute(thread2, task2);
            }

            @Override
            protected void afterExecute(Runnable task2, Throwable ex) {
                ThreadPoolTaskScheduler.this.afterExecute(task2, ex);
            }

            @Override
            protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task2) {
                return ThreadPoolTaskScheduler.this.decorateTaskIfNecessary(task2);
            }

            @Override
            protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task2) {
                return ThreadPoolTaskScheduler.this.decorateTaskIfNecessary(task2);
            }
        };
    }

    public ScheduledExecutorService getScheduledExecutor() throws IllegalStateException {
        Assert.state(this.scheduledExecutor != null, "ThreadPoolTaskScheduler not initialized");
        return this.scheduledExecutor;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() throws IllegalStateException {
        Assert.state(this.scheduledExecutor instanceof ScheduledThreadPoolExecutor, "No ScheduledThreadPoolExecutor available");
        return (ScheduledThreadPoolExecutor)this.scheduledExecutor;
    }

    public int getPoolSize() {
        if (this.scheduledExecutor == null) {
            return this.poolSize;
        }
        return this.getScheduledThreadPoolExecutor().getPoolSize();
    }

    public int getActiveCount() {
        if (this.scheduledExecutor == null) {
            return 0;
        }
        return this.getScheduledThreadPoolExecutor().getActiveCount();
    }

    @Deprecated
    public boolean isRemoveOnCancelPolicy() {
        if (this.scheduledExecutor == null) {
            return this.removeOnCancelPolicy;
        }
        return this.getScheduledThreadPoolExecutor().getRemoveOnCancelPolicy();
    }

    @Override
    public void execute(Runnable task2) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            executor.execute(this.errorHandlingTask(task2, false));
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    @Override
    public Future<?> submit(Runnable task2) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.submit(this.errorHandlingTask(task2, false));
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task2) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.submit(new DelegatingErrorHandlingCallable<T>(task2, this.errorHandler));
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task2) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            ListenableFutureTask<Object> listenableFuture = new ListenableFutureTask<Object>(task2, null);
            this.executeAndTrack(executor, listenableFuture);
            return listenableFuture;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> task2) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            ListenableFutureTask<T> listenableFuture = new ListenableFutureTask<T>(task2);
            this.executeAndTrack(executor, listenableFuture);
            return listenableFuture;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    private void executeAndTrack(ExecutorService executor, ListenableFutureTask<?> listenableFuture) {
        Future<?> scheduledFuture = executor.submit(this.errorHandlingTask(listenableFuture, false));
        this.listenableFutureMap.put(scheduledFuture, listenableFuture);
        listenableFuture.addCallback(result -> this.listenableFutureMap.remove(scheduledFuture), ex -> this.listenableFutureMap.remove(scheduledFuture));
    }

    @Override
    protected void cancelRemainingTask(Runnable task2) {
        super.cancelRemainingTask(task2);
        ListenableFuture<?> listenableFuture = this.listenableFutureMap.get(task2);
        if (listenableFuture != null) {
            listenableFuture.cancel(true);
        }
    }

    @Override
    @Nullable
    public ScheduledFuture<?> schedule(Runnable task2, Trigger trigger) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            ErrorHandler errorHandler = this.errorHandler;
            if (errorHandler == null) {
                errorHandler = TaskUtils.getDefaultErrorHandler(true);
            }
            return new ReschedulingRunnable(task2, trigger, this.clock, executor, errorHandler).schedule();
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task2, Instant startTime) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        Duration delay = Duration.between(this.clock.instant(), startTime);
        try {
            return executor.schedule(this.errorHandlingTask(task2, false), NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task2, Instant startTime, Duration period) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return executor.scheduleAtFixedRate(this.errorHandlingTask(task2, true), NANO.convert(initialDelay), NANO.convert(period), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task2, Duration period) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.scheduleAtFixedRate(this.errorHandlingTask(task2, true), 0L, NANO.convert(period), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task2, Instant startTime, Duration delay) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        Duration initialDelay = Duration.between(this.clock.instant(), startTime);
        try {
            return executor.scheduleWithFixedDelay(this.errorHandlingTask(task2, true), NANO.convert(initialDelay), NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task2, Duration delay) {
        ScheduledExecutorService executor = this.getScheduledExecutor();
        try {
            return executor.scheduleWithFixedDelay(this.errorHandlingTask(task2, true), 0L, NANO.convert(delay), NANO);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(executor, task2, ex);
        }
    }

    private <V> RunnableScheduledFuture<V> decorateTaskIfNecessary(RunnableScheduledFuture<V> future) {
        return this.taskDecorator != null ? new DelegatingRunnableScheduledFuture(future, this.taskDecorator) : future;
    }

    private Runnable errorHandlingTask(Runnable task2, boolean isRepeatingTask) {
        return TaskUtils.decorateTaskWithErrorHandler(task2, this.errorHandler, isRepeatingTask);
    }

    private static class DelegatingRunnableScheduledFuture<V>
    implements RunnableScheduledFuture<V> {
        private final RunnableScheduledFuture<V> future;
        private final Runnable decoratedRunnable;

        public DelegatingRunnableScheduledFuture(RunnableScheduledFuture<V> future, TaskDecorator taskDecorator) {
            this.future = future;
            this.decoratedRunnable = taskDecorator.decorate(this.future);
        }

        @Override
        public void run() {
            this.decoratedRunnable.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.future.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit);
        }

        @Override
        public boolean isPeriodic() {
            return this.future.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.future.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.future.compareTo(o);
        }
    }
}

