/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.Trigger;

public interface TaskScheduler {
    default public Clock getClock() {
        return Clock.systemDefaultZone();
    }

    @Nullable
    public ScheduledFuture<?> schedule(Runnable var1, Trigger var2);

    public ScheduledFuture<?> schedule(Runnable var1, Instant var2);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> schedule(Runnable task2, Date startTime) {
        return this.schedule(task2, startTime.toInstant());
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable var1, Instant var2, Duration var3);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> scheduleAtFixedRate(Runnable task2, Date startTime, long period) {
        return this.scheduleAtFixedRate(task2, startTime.toInstant(), Duration.ofMillis(period));
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable var1, Duration var2);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> scheduleAtFixedRate(Runnable task2, long period) {
        return this.scheduleAtFixedRate(task2, Duration.ofMillis(period));
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable var1, Instant var2, Duration var3);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task2, Date startTime, long delay) {
        return this.scheduleWithFixedDelay(task2, startTime.toInstant(), Duration.ofMillis(delay));
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable var1, Duration var2);

    @Deprecated(since="6.0")
    default public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task2, long delay) {
        return this.scheduleWithFixedDelay(task2, Duration.ofMillis(delay));
    }
}

