/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.stomp;

import java.util.concurrent.CompletableFuture;
import org.springframework.lang.Nullable;
import org.springframework.messaging.simp.SimpLogging;
import org.springframework.messaging.simp.stomp.ConnectionHandlingStompSession;
import org.springframework.messaging.simp.stomp.StompBrokerRelayMessageHandler;
import org.springframework.messaging.simp.stomp.StompClientSupport;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompReactorNettyCodec;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.messaging.simp.stomp.StompTcpMessageCodec;
import org.springframework.messaging.tcp.TcpOperations;
import org.springframework.messaging.tcp.reactor.ReactorNetty2TcpClient;
import org.springframework.messaging.tcp.reactor.ReactorNettyTcpClient;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;

public class ReactorNettyTcpStompClient
extends StompClientSupport {
    private static final boolean reactorNettyClientPresent;
    private static final boolean reactorNetty2ClientPresent;
    private final TcpOperations<byte[]> tcpClient;

    public ReactorNettyTcpStompClient() {
        this("127.0.0.1", 61613);
    }

    public ReactorNettyTcpStompClient(String host, int port) {
        this.tcpClient = ReactorNettyTcpStompClient.initTcpClient(host, port);
    }

    public ReactorNettyTcpStompClient(TcpOperations<byte[]> tcpClient) {
        Assert.notNull(tcpClient, "'tcpClient' is required");
        this.tcpClient = tcpClient;
    }

    private static TcpOperations<byte[]> initTcpClient(String host, int port) {
        if (reactorNettyClientPresent) {
            ReactorNettyTcpClient<byte[]> client = new ReactorNettyTcpClient<byte[]>(host, port, new StompReactorNettyCodec());
            client.setLogger(SimpLogging.forLog(client.getLogger()));
            return client;
        }
        if (reactorNetty2ClientPresent) {
            ReactorNetty2TcpClient<byte[]> client = new ReactorNetty2TcpClient<byte[]>(host, port, new StompTcpMessageCodec());
            client.setLogger(SimpLogging.forLog(client.getLogger()));
            return client;
        }
        throw new IllegalStateException("No compatible version of Reactor Netty");
    }

    @Deprecated(since="6.0", forRemoval=true)
    public ListenableFuture<StompSession> connect(StompSessionHandler handler) {
        return new CompletableToListenableFutureAdapter<StompSession>(this.connectAsync(handler));
    }

    public CompletableFuture<StompSession> connectAsync(StompSessionHandler handler) {
        return this.connectAsync(null, handler);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public ListenableFuture<StompSession> connect(@Nullable StompHeaders connectHeaders, StompSessionHandler handler) {
        ConnectionHandlingStompSession session = this.createSession(connectHeaders, handler);
        this.tcpClient.connectAsync(session);
        return session.getSessionFuture();
    }

    public CompletableFuture<StompSession> connectAsync(@Nullable StompHeaders connectHeaders, StompSessionHandler handler) {
        ConnectionHandlingStompSession session = this.createSession(connectHeaders, handler);
        this.tcpClient.connectAsync(session);
        return session.getSession();
    }

    public void shutdown() {
        this.tcpClient.shutdownAsync();
    }

    public String toString() {
        return "ReactorNettyTcpStompClient[" + this.tcpClient + "]";
    }

    static {
        ClassLoader classLoader = StompBrokerRelayMessageHandler.class.getClassLoader();
        reactorNettyClientPresent = ClassUtils.isPresent("reactor.netty.http.client.HttpClient", classLoader);
        reactorNetty2ClientPresent = ClassUtils.isPresent("reactor.netty5.http.client.HttpClient", classLoader);
    }
}

