/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.broker;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.support.ExecutorChannelInterceptor;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;

public class OrderedMessageChannelDecorator
implements MessageChannel {
    private static final String NEXT_MESSAGE_TASK_HEADER = "simpNextMessageTask";
    private final MessageChannel channel;
    private final int subscriberCount;
    private final Log logger;
    private final Queue<Message<?>> messages = new ConcurrentLinkedQueue();
    private final AtomicBoolean sendInProgress = new AtomicBoolean();

    public OrderedMessageChannelDecorator(MessageChannel channel, Log logger) {
        int n;
        this.channel = channel;
        if (channel instanceof ExecutorSubscribableChannel) {
            ExecutorSubscribableChannel ch = (ExecutorSubscribableChannel)channel;
            n = ch.getSubscribers().size();
        } else {
            n = 0;
        }
        this.subscriberCount = n;
        this.logger = logger;
    }

    @Override
    public boolean send(Message<?> message2) {
        return this.send(message2, -1L);
    }

    @Override
    public boolean send(Message<?> message2, long timeout) {
        this.messages.add(message2);
        this.trySend();
        return true;
    }

    private void trySend() {
        if (this.messages.isEmpty()) {
            return;
        }
        if (this.sendInProgress.compareAndSet(false, true)) {
            this.sendNextMessage();
        }
    }

    private void sendNextMessage() {
        Message<?> message2;
        while ((message2 = this.messages.peek()) != null) {
            block4: {
                try {
                    OrderedMessageChannelDecorator.setTaskHeader(message2, new PostHandleTask(message2));
                    if (this.channel.send(message2)) {
                        return;
                    }
                }
                catch (Throwable ex) {
                    if (!this.logger.isErrorEnabled()) break block4;
                    this.logger.error("Failed to send " + message2, ex);
                }
            }
            this.removeMessage(message2);
        }
        this.sendInProgress.set(false);
        this.trySend();
    }

    private boolean removeMessage(Message<?> message2) {
        Message<?> next = this.messages.peek();
        if (next == message2) {
            this.messages.remove();
            return true;
        }
        return false;
    }

    private static void setTaskHeader(Message<?> message2, Runnable task2) {
        SimpMessageHeaderAccessor accessor = MessageHeaderAccessor.getAccessor(message2, SimpMessageHeaderAccessor.class);
        Assert.isTrue(accessor != null && accessor.isMutable(), "Expected mutable SimpMessageHeaderAccessor");
        accessor.setHeader(NEXT_MESSAGE_TASK_HEADER, task2);
    }

    public static void configureInterceptor(MessageChannel channel, boolean preserveOrder) {
        if (preserveOrder) {
            Assert.isInstanceOf(ExecutorSubscribableChannel.class, (Object)channel, "An ExecutorSubscribableChannel is required for 'preservePublishOrder'");
            ExecutorSubscribableChannel execChannel = (ExecutorSubscribableChannel)channel;
            if (execChannel.getInterceptors().stream().noneMatch(CallbackTaskInterceptor.class::isInstance)) {
                execChannel.addInterceptor(0, new CallbackTaskInterceptor());
            }
        } else if (channel instanceof ExecutorSubscribableChannel) {
            ExecutorSubscribableChannel execChannel = (ExecutorSubscribableChannel)channel;
            execChannel.getInterceptors().stream().filter(CallbackTaskInterceptor.class::isInstance).findFirst().map(execChannel::removeInterceptor);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean supportsOrderedMessages(MessageChannel channel) {
        if (!(channel instanceof ExecutorSubscribableChannel)) return false;
        ExecutorSubscribableChannel ch = (ExecutorSubscribableChannel)channel;
        if (!ch.getInterceptors().stream().anyMatch(CallbackTaskInterceptor.class::isInstance)) return false;
        return true;
    }

    @Nullable
    public static Runnable getNextMessageTask(Message<?> message2) {
        return (Runnable)message2.getHeaders().get(NEXT_MESSAGE_TASK_HEADER);
    }

    private final class PostHandleTask
    implements Runnable {
        private final Message<?> message;
        @Nullable
        private final AtomicInteger handledCount;

        private PostHandleTask(Message<?> message2) {
            this.message = message2;
            this.handledCount = OrderedMessageChannelDecorator.this.subscriberCount > 1 ? new AtomicInteger(0) : null;
        }

        @Override
        public void run() {
            if ((this.handledCount == null || this.handledCount.addAndGet(1) == OrderedMessageChannelDecorator.this.subscriberCount) && OrderedMessageChannelDecorator.this.removeMessage(this.message)) {
                OrderedMessageChannelDecorator.this.sendNextMessage();
            }
        }
    }

    private static final class CallbackTaskInterceptor
    implements ExecutorChannelInterceptor {
        private CallbackTaskInterceptor() {
        }

        @Override
        public void afterMessageHandled(Message<?> message2, MessageChannel ch, MessageHandler handler, @Nullable Exception ex) {
            Runnable task2 = OrderedMessageChannelDecorator.getNextMessageTask(message2);
            if (task2 != null) {
                task2.run();
            }
        }
    }
}

