/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.broker;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.simp.SimpLogging;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.broker.BrokerAvailabilityEvent;
import org.springframework.messaging.simp.broker.OrderedMessageChannelDecorator;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.InterceptableChannel;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class AbstractBrokerMessageHandler
implements MessageHandler,
ApplicationEventPublisherAware,
SmartLifecycle {
    protected final Log logger = SimpLogging.forLogName(this.getClass());
    private final SubscribableChannel clientInboundChannel;
    private final MessageChannel clientOutboundChannel;
    private final SubscribableChannel brokerChannel;
    private final Collection<String> destinationPrefixes;
    @Nullable
    private Predicate<String> userDestinationPredicate;
    private boolean preservePublishOrder = false;
    @Nullable
    private ApplicationEventPublisher eventPublisher;
    private final AtomicBoolean brokerAvailable = new AtomicBoolean();
    private final BrokerAvailabilityEvent availableEvent = new BrokerAvailabilityEvent(true, this);
    private final BrokerAvailabilityEvent notAvailableEvent = new BrokerAvailabilityEvent(false, this);
    private boolean autoStartup = true;
    @Nullable
    private Integer phase;
    private volatile boolean running;
    private final Object lifecycleMonitor = new Object();
    private final ChannelInterceptor unsentDisconnectInterceptor = new UnsentDisconnectChannelInterceptor();

    public AbstractBrokerMessageHandler(SubscribableChannel inboundChannel, MessageChannel outboundChannel, SubscribableChannel brokerChannel) {
        this(inboundChannel, outboundChannel, brokerChannel, Collections.emptyList());
    }

    public AbstractBrokerMessageHandler(SubscribableChannel inboundChannel, MessageChannel outboundChannel, SubscribableChannel brokerChannel, @Nullable Collection<String> destinationPrefixes) {
        Assert.notNull((Object)inboundChannel, "'inboundChannel' must not be null");
        Assert.notNull((Object)outboundChannel, "'outboundChannel' must not be null");
        Assert.notNull((Object)brokerChannel, "'brokerChannel' must not be null");
        this.clientInboundChannel = inboundChannel;
        this.clientOutboundChannel = outboundChannel;
        this.brokerChannel = brokerChannel;
        destinationPrefixes = destinationPrefixes != null ? destinationPrefixes : Collections.emptyList();
        this.destinationPrefixes = Collections.unmodifiableCollection(destinationPrefixes);
    }

    public SubscribableChannel getClientInboundChannel() {
        return this.clientInboundChannel;
    }

    public MessageChannel getClientOutboundChannel() {
        return this.clientOutboundChannel;
    }

    public SubscribableChannel getBrokerChannel() {
        return this.brokerChannel;
    }

    public Collection<String> getDestinationPrefixes() {
        return this.destinationPrefixes;
    }

    public void setUserDestinationPredicate(@Nullable Predicate<String> predicate) {
        this.userDestinationPredicate = predicate;
    }

    public void setPreservePublishOrder(boolean preservePublishOrder) {
        OrderedMessageChannelDecorator.configureInterceptor(this.clientOutboundChannel, preservePublishOrder);
        this.preservePublishOrder = preservePublishOrder;
    }

    public boolean isPreservePublishOrder() {
        return this.preservePublishOrder;
    }

    @Override
    public void setApplicationEventPublisher(@Nullable ApplicationEventPublisher publisher) {
        this.eventPublisher = publisher;
    }

    @Nullable
    public ApplicationEventPublisher getApplicationEventPublisher() {
        return this.eventPublisher;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Override
    public int getPhase() {
        return this.phase != null ? this.phase.intValue() : SmartLifecycle.super.getPhase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.logger.info("Starting...");
            this.clientInboundChannel.subscribe(this);
            this.brokerChannel.subscribe(this);
            SubscribableChannel subscribableChannel = this.clientInboundChannel;
            if (subscribableChannel instanceof InterceptableChannel) {
                InterceptableChannel ic = (InterceptableChannel)((Object)subscribableChannel);
                ic.addInterceptor(0, this.unsentDisconnectInterceptor);
            }
            this.startInternal();
            this.running = true;
            this.logger.info("Started.");
        }
    }

    protected void startInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.logger.info("Stopping...");
            this.stopInternal();
            this.clientInboundChannel.unsubscribe(this);
            this.brokerChannel.unsubscribe(this);
            SubscribableChannel subscribableChannel = this.clientInboundChannel;
            if (subscribableChannel instanceof InterceptableChannel) {
                InterceptableChannel ic = (InterceptableChannel)((Object)subscribableChannel);
                ic.removeInterceptor(this.unsentDisconnectInterceptor);
            }
            this.running = false;
            this.logger.info("Stopped.");
        }
    }

    protected void stopInternal() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    public boolean isBrokerAvailable() {
        return this.brokerAvailable.get();
    }

    @Override
    public void handleMessage(Message<?> message2) {
        if (!this.running) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this + " not running yet. Ignoring " + message2);
            }
            return;
        }
        this.handleMessageInternal(message2);
    }

    protected abstract void handleMessageInternal(Message<?> var1);

    protected boolean checkDestinationPrefix(@Nullable String destination) {
        if (destination == null) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.destinationPrefixes)) {
            return !this.isUserDestination(destination);
        }
        for (String prefix : this.destinationPrefixes) {
            if (!destination.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isUserDestination(String destination) {
        return this.userDestinationPredicate != null && this.userDestinationPredicate.test(destination);
    }

    protected void publishBrokerAvailableEvent() {
        boolean shouldPublish = this.brokerAvailable.compareAndSet(false, true);
        if (this.eventPublisher != null && shouldPublish) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.availableEvent);
            }
            this.eventPublisher.publishEvent(this.availableEvent);
        }
    }

    protected void publishBrokerUnavailableEvent() {
        boolean shouldPublish = this.brokerAvailable.compareAndSet(true, false);
        if (this.eventPublisher != null && shouldPublish) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.notAvailableEvent);
            }
            this.eventPublisher.publishEvent(this.notAvailableEvent);
        }
    }

    protected MessageChannel getClientOutboundChannelForSession(String sessionId) {
        return this.preservePublishOrder ? new OrderedMessageChannelDecorator(this.getClientOutboundChannel(), this.logger) : this.getClientOutboundChannel();
    }

    private class UnsentDisconnectChannelInterceptor
    implements ChannelInterceptor {
        private UnsentDisconnectChannelInterceptor() {
        }

        @Override
        public void afterSendCompletion(Message<?> message2, MessageChannel channel, boolean sent, @Nullable Exception ex) {
            SimpMessageType messageType;
            if (!sent && SimpMessageType.DISCONNECT.equals((Object)(messageType = SimpMessageHeaderAccessor.getMessageType(message2.getHeaders())))) {
                AbstractBrokerMessageHandler.this.logger.debug("Detected unsent DISCONNECT message. Processing anyway.");
                AbstractBrokerMessageHandler.this.handleMessage(message2);
            }
        }
    }
}

