/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation.reactive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.reactive.HandlerMethodReturnValueHandler;
import reactor.core.publisher.Mono;

public class HandlerMethodReturnValueHandlerComposite
implements HandlerMethodReturnValueHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();

    public List<HandlerMethodReturnValueHandler> getReturnValueHandlers() {
        return Collections.unmodifiableList(this.returnValueHandlers);
    }

    public void clear() {
        this.returnValueHandlers.clear();
    }

    public HandlerMethodReturnValueHandlerComposite addHandler(HandlerMethodReturnValueHandler returnValueHandler) {
        this.returnValueHandlers.add(returnValueHandler);
        return this;
    }

    public HandlerMethodReturnValueHandlerComposite addHandlers(@Nullable List<? extends HandlerMethodReturnValueHandler> handlers) {
        if (handlers != null) {
            this.returnValueHandlers.addAll(handlers);
        }
        return this;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.getReturnValueHandler(returnType) != null;
    }

    @Override
    public Mono<Void> handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, Message<?> message2) {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        if (handler == null) {
            throw new IllegalStateException("No handler for return value type: " + returnType.getParameterType());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Processing return value with " + handler);
        }
        return handler.handleReturnValue(returnValue, returnType, message2);
    }

    @Nullable
    private HandlerMethodReturnValueHandler getReturnValueHandler(MethodParameter returnType) {
        for (HandlerMethodReturnValueHandler handler : this.returnValueHandlers) {
            if (!handler.supportsReturnType(returnType)) continue;
            return handler;
        }
        return null;
    }
}

