/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;

public class MethodArgumentResolutionException
extends MessagingException {
    private final MethodParameter parameter;

    public MethodArgumentResolutionException(Message<?> message2, MethodParameter parameter) {
        super(message2, MethodArgumentResolutionException.getMethodParameterMessage(parameter));
        this.parameter = parameter;
    }

    public MethodArgumentResolutionException(Message<?> message2, MethodParameter parameter, String description) {
        super(message2, MethodArgumentResolutionException.getMethodParameterMessage(parameter) + ": " + description);
        this.parameter = parameter;
    }

    public MethodArgumentResolutionException(Message<?> message2, MethodParameter parameter, String description, @Nullable Throwable cause) {
        super(message2, MethodArgumentResolutionException.getMethodParameterMessage(parameter) + ": " + description, cause);
        this.parameter = parameter;
    }

    public final MethodParameter getMethodParameter() {
        return this.parameter;
    }

    private static String getMethodParameterMessage(MethodParameter parameter) {
        return "Could not resolve method parameter at index " + parameter.getParameterIndex() + " in " + parameter.getExecutable().toGenericString();
    }
}

