/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.invocation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.AsyncHandlerMethodReturnValueHandler;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;

public class HandlerMethodReturnValueHandlerComposite
implements AsyncHandlerMethodReturnValueHandler {
    public static final Log defaultLogger = LogFactory.getLog(HandlerMethodReturnValueHandlerComposite.class);
    private Log logger = defaultLogger;
    private final List<HandlerMethodReturnValueHandler> returnValueHandlers = new ArrayList<HandlerMethodReturnValueHandler>();

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public Log getLogger() {
        return this.logger;
    }

    public List<HandlerMethodReturnValueHandler> getReturnValueHandlers() {
        return Collections.unmodifiableList(this.returnValueHandlers);
    }

    public void clear() {
        this.returnValueHandlers.clear();
    }

    public HandlerMethodReturnValueHandlerComposite addHandler(HandlerMethodReturnValueHandler returnValueHandler) {
        this.returnValueHandlers.add(returnValueHandler);
        return this;
    }

    public HandlerMethodReturnValueHandlerComposite addHandlers(@Nullable List<? extends HandlerMethodReturnValueHandler> handlers) {
        if (handlers != null) {
            this.returnValueHandlers.addAll(handlers);
        }
        return this;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        return this.getReturnValueHandler(returnType) != null;
    }

    @Nullable
    private HandlerMethodReturnValueHandler getReturnValueHandler(MethodParameter returnType) {
        for (HandlerMethodReturnValueHandler handler : this.returnValueHandlers) {
            if (!handler.supportsReturnType(returnType)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void handleReturnValue(@Nullable Object returnValue, MethodParameter returnType, Message<?> message2) throws Exception {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        if (handler == null) {
            throw new IllegalStateException("No handler for return value type: " + returnType.getParameterType());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Processing return value with " + handler);
        }
        handler.handleReturnValue(returnValue, returnType, message2);
    }

    @Override
    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        AsyncHandlerMethodReturnValueHandler asyncHandler;
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        return handler instanceof AsyncHandlerMethodReturnValueHandler && (asyncHandler = (AsyncHandlerMethodReturnValueHandler)handler).isAsyncReturnValue(returnValue, returnType);
    }

    @Override
    @Nullable
    public CompletableFuture<?> toCompletableFuture(Object returnValue, MethodParameter returnType) {
        HandlerMethodReturnValueHandler handler = this.getReturnValueHandler(returnType);
        if (handler instanceof AsyncHandlerMethodReturnValueHandler) {
            AsyncHandlerMethodReturnValueHandler asyncHandler = (AsyncHandlerMethodReturnValueHandler)handler;
            return asyncHandler.toCompletableFuture(returnValue, returnType);
        }
        return null;
    }
}

