/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.messaging.handler.annotation.support.MethodArgumentTypeMismatchException;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MessageMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Nullable
    private final MessageConverter converter;

    public MessageMethodArgumentResolver() {
        this(null);
    }

    public MessageMethodArgumentResolver(@Nullable MessageConverter converter) {
        this.converter = converter;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return Message.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Message<?> message2) throws Exception {
        Class<?> targetMessageType = parameter.getParameterType();
        Class<?> targetPayloadType = this.getPayloadType(parameter, message2);
        if (!targetMessageType.isAssignableFrom(message2.getClass())) {
            throw new MethodArgumentTypeMismatchException(message2, parameter, "Actual message type '" + ClassUtils.getDescriptiveType(message2) + "' does not match expected type '" + ClassUtils.getQualifiedName(targetMessageType) + "'");
        }
        Object payload = message2.getPayload();
        if (targetPayloadType.isInstance(payload)) {
            return message2;
        }
        if (this.isEmptyPayload(payload)) {
            throw new MessageConversionException(message2, "Cannot convert from actual payload type '" + ClassUtils.getDescriptiveType(payload) + "' to expected payload type '" + ClassUtils.getQualifiedName(targetPayloadType) + "' when payload is empty");
        }
        payload = this.convertPayload(message2, parameter, targetPayloadType);
        return MessageBuilder.createMessage(payload, message2.getHeaders());
    }

    protected Class<?> getPayloadType(MethodParameter parameter, Message<?> message2) {
        Type genericParamType = parameter.getGenericParameterType();
        ResolvableType resolvableType = ResolvableType.forType(genericParamType).as(Message.class);
        return resolvableType.getGeneric(new int[0]).toClass();
    }

    protected boolean isEmptyPayload(@Nullable Object payload) {
        if (payload == null) {
            return true;
        }
        if (payload instanceof byte[]) {
            byte[] bytes = (byte[])payload;
            return bytes.length == 0;
        }
        if (payload instanceof String) {
            String text = (String)payload;
            return !StringUtils.hasText(text);
        }
        return false;
    }

    private Object convertPayload(Message<?> message2, MethodParameter parameter, Class<?> targetPayloadType) {
        Object result = null;
        MessageConverter messageConverter = this.converter;
        if (messageConverter instanceof SmartMessageConverter) {
            SmartMessageConverter smartConverter = (SmartMessageConverter)messageConverter;
            result = smartConverter.fromMessage(message2, targetPayloadType, parameter);
        } else if (this.converter != null) {
            result = this.converter.fromMessage(message2, targetPayloadType);
        }
        if (result == null) {
            throw new MessageConversionException(message2, "No converter found from actual payload type '" + ClassUtils.getDescriptiveType(message2.getPayload()) + "' to expected payload type '" + ClassUtils.getQualifiedName(targetPayloadType) + "'");
        }
        return result;
    }
}

