/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.core.AbstractMessageSendingTemplate;
import org.springframework.messaging.core.MessageReceivingOperations;

public abstract class AbstractMessageReceivingTemplate<D>
extends AbstractMessageSendingTemplate<D>
implements MessageReceivingOperations<D> {
    @Override
    @Nullable
    public Message<?> receive() {
        return this.doReceive(this.getRequiredDefaultDestination());
    }

    @Override
    @Nullable
    public Message<?> receive(D destination) {
        return this.doReceive(destination);
    }

    @Nullable
    protected abstract Message<?> doReceive(D var1);

    @Override
    @Nullable
    public <T> T receiveAndConvert(Class<T> targetClass) {
        return this.receiveAndConvert(this.getRequiredDefaultDestination(), targetClass);
    }

    @Override
    @Nullable
    public <T> T receiveAndConvert(D destination, Class<T> targetClass) {
        Message<?> message2 = this.doReceive(destination);
        if (message2 != null) {
            return this.doConvert(message2, targetClass);
        }
        return null;
    }

    @Nullable
    protected <T> T doConvert(Message<?> message2, Class<T> targetClass) {
        MessageConverter messageConverter = this.getMessageConverter();
        Object value = messageConverter.fromMessage(message2, targetClass);
        if (value == null) {
            throw new MessageConversionException(message2, "Unable to convert payload [" + message2.getPayload() + "] to type [" + targetClass + "] using converter [" + messageConverter + "]");
        }
        return (T)value;
    }
}

