/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.SmartMessageConverter;
import org.springframework.util.Assert;

public class CompositeMessageConverter
implements SmartMessageConverter {
    private final List<MessageConverter> converters;

    public CompositeMessageConverter(Collection<MessageConverter> converters) {
        Assert.notEmpty(converters, "Converters must not be empty");
        this.converters = new ArrayList<MessageConverter>(converters);
    }

    @Override
    @Nullable
    public Object fromMessage(Message<?> message2, Class<?> targetClass) {
        for (MessageConverter converter : this.getConverters()) {
            Object result = converter.fromMessage(message2, targetClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public Object fromMessage(Message<?> message2, Class<?> targetClass, @Nullable Object conversionHint) {
        for (MessageConverter converter : this.getConverters()) {
            Object result;
            Object object;
            if (converter instanceof SmartMessageConverter) {
                SmartMessageConverter smartMessageConverter = (SmartMessageConverter)converter;
                object = smartMessageConverter.fromMessage(message2, targetClass, conversionHint);
            } else {
                object = converter.fromMessage(message2, targetClass);
            }
            if ((result = object) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public Message<?> toMessage(Object payload, @Nullable MessageHeaders headers) {
        for (MessageConverter converter : this.getConverters()) {
            Message<?> result = converter.toMessage(payload, headers);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public Message<?> toMessage(Object payload, @Nullable MessageHeaders headers, @Nullable Object conversionHint) {
        for (MessageConverter converter : this.getConverters()) {
            Message<?> result;
            Message<?> message2;
            if (converter instanceof SmartMessageConverter) {
                SmartMessageConverter smartMessageConverter = (SmartMessageConverter)converter;
                message2 = smartMessageConverter.toMessage(payload, headers, conversionHint);
            } else {
                message2 = converter.toMessage(payload, headers);
            }
            if ((result = message2) == null) continue;
            return result;
        }
        return null;
    }

    public List<MessageConverter> getConverters() {
        return this.converters;
    }

    public String toString() {
        return "CompositeMessageConverter[converters=" + this.getConverters() + "]";
    }
}

