/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ServletServerHttpResponse
implements ServerHttpResponse {
    private final HttpServletResponse servletResponse;
    private final HttpHeaders headers;
    private boolean headersWritten = false;
    private boolean bodyUsed = false;
    @Nullable
    private HttpHeaders readOnlyHeaders;

    public ServletServerHttpResponse(HttpServletResponse servletResponse) {
        Assert.notNull((Object)servletResponse, "HttpServletResponse must not be null");
        this.servletResponse = servletResponse;
        this.headers = new ServletResponseHttpHeaders();
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    @Override
    public void setStatusCode(HttpStatusCode status) {
        Assert.notNull((Object)status, "HttpStatusCode must not be null");
        this.servletResponse.setStatus(status.value());
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.readOnlyHeaders != null) {
            return this.readOnlyHeaders;
        }
        if (this.headersWritten) {
            this.readOnlyHeaders = HttpHeaders.readOnlyHttpHeaders(this.headers);
            return this.readOnlyHeaders;
        }
        return this.headers;
    }

    @Override
    public OutputStream getBody() throws IOException {
        this.bodyUsed = true;
        this.writeHeaders();
        return this.servletResponse.getOutputStream();
    }

    @Override
    public void flush() throws IOException {
        this.writeHeaders();
        if (this.bodyUsed) {
            this.servletResponse.flushBuffer();
        }
    }

    @Override
    public void close() {
        this.writeHeaders();
    }

    private void writeHeaders() {
        if (!this.headersWritten) {
            long contentLength;
            this.getHeaders().forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(headerName, headerValues) -> {
                for (String headerValue : headerValues) {
                    this.servletResponse.addHeader((String)headerName, headerValue);
                }
            }));
            MediaType contentTypeHeader = this.headers.getContentType();
            if (this.servletResponse.getContentType() == null && contentTypeHeader != null) {
                this.servletResponse.setContentType(contentTypeHeader.toString());
            }
            if (this.servletResponse.getCharacterEncoding() == null && contentTypeHeader != null && contentTypeHeader.getCharset() != null) {
                this.servletResponse.setCharacterEncoding(contentTypeHeader.getCharset().name());
            }
            if ((contentLength = this.getHeaders().getContentLength()) != -1L) {
                this.servletResponse.setContentLengthLong(contentLength);
            }
            this.headersWritten = true;
        }
    }

    private class ServletResponseHttpHeaders
    extends HttpHeaders {
        private static final long serialVersionUID = 3410708522401046302L;

        private ServletResponseHttpHeaders() {
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(key) || this.get(key) != null;
        }

        @Override
        @Nullable
        public String getFirst(String headerName) {
            if (headerName.equalsIgnoreCase("Content-Type")) {
                String value = super.getFirst(headerName);
                return value != null ? value : ServletServerHttpResponse.this.servletResponse.getContentType();
            }
            String value = ServletServerHttpResponse.this.servletResponse.getHeader(headerName);
            return value != null ? value : super.getFirst(headerName);
        }

        @Override
        @Nullable
        public List<String> get(Object key) {
            Assert.isInstanceOf(String.class, key, "Key must be a String-based header name");
            String headerName = (String)key;
            if (headerName.equalsIgnoreCase("Content-Type")) {
                String value = this.getFirst(headerName);
                return value != null ? Collections.singletonList(value) : null;
            }
            Collection<String> values1 = ServletServerHttpResponse.this.servletResponse.getHeaders(headerName);
            if (ServletServerHttpResponse.this.headersWritten) {
                return new ArrayList<String>(values1);
            }
            boolean isEmpty1 = CollectionUtils.isEmpty(values1);
            Object values2 = super.get(key);
            boolean isEmpty2 = CollectionUtils.isEmpty(values2);
            if (isEmpty1 && isEmpty2) {
                return null;
            }
            ArrayList<String> values3 = new ArrayList<String>();
            if (!isEmpty1) {
                values3.addAll(values1);
            }
            if (!isEmpty2) {
                values3.addAll((Collection<String>)values2);
            }
            return values3;
        }
    }
}

