/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.protobuf;

import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ProtobufJsonDecoder
implements Decoder<Message> {
    protected static final int DEFAULT_MESSAGE_MAX_SIZE = 262144;
    private static final List<MimeType> defaultMimeTypes = List.of(MediaType.APPLICATION_JSON, new MediaType("application", "*+json"));
    private static final ConcurrentMap<Class<?>, Method> methodCache = new ConcurrentReferenceHashMap();
    private final JsonFormat.Parser parser;
    private int maxMessageSize = 262144;

    public ProtobufJsonDecoder() {
        this(JsonFormat.parser());
    }

    public ProtobufJsonDecoder(JsonFormat.Parser parser) {
        this.parser = parser;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return Message.class.isAssignableFrom(elementType.toClass()) && ProtobufJsonDecoder.supportsMimeType(mimeType);
    }

    private static boolean supportsMimeType(@Nullable MimeType mimeType) {
        if (mimeType == null) {
            return false;
        }
        for (MimeType m : defaultMimeTypes) {
            if (!m.isCompatibleWith(mimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<MimeType> getDecodableMimeTypes() {
        return defaultMimeTypes;
    }

    @Override
    public Flux<Message> decode(Publisher<DataBuffer> inputStream, ResolvableType targetType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.error((Throwable)new UnsupportedOperationException("Protobuf decoder does not support Flux, use Mono<List<...>> instead."));
    }

    @Override
    public Message decode(DataBuffer dataBuffer, ResolvableType targetType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) throws DecodingException {
        try {
            Message.Builder builder = ProtobufJsonDecoder.getMessageBuilder(targetType.toClass());
            this.parser.merge((Reader)new InputStreamReader(dataBuffer.asInputStream()), builder);
            Message message2 = builder.build();
            return message2;
        }
        catch (Exception ex) {
            throw new DecodingException("Could not read Protobuf message: " + ex.getMessage(), ex);
        }
        finally {
            DataBufferUtils.release(dataBuffer);
        }
    }

    private static Message.Builder getMessageBuilder(Class<?> clazz) throws Exception {
        Method method = (Method)methodCache.get(clazz);
        if (method == null) {
            method = clazz.getMethod("newBuilder", new Class[0]);
            methodCache.put(clazz, method);
        }
        return (Message.Builder)method.invoke(clazz, new Object[0]);
    }

    @Override
    public Mono<Message> decodeToMono(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return DataBufferUtils.join(inputStream, this.maxMessageSize).map(dataBuffer -> this.decode((DataBuffer)dataBuffer, elementType, mimeType, hints)).onErrorMap(DataBufferLimitException.class, exc -> new DecodingException("Could not decode JSON as Protobuf message", (Throwable)exc));
    }
}

