/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.protobuf;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageEncoder;
import org.springframework.http.codec.protobuf.ProtobufCodecSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ProtobufEncoder
extends ProtobufCodecSupport
implements HttpMessageEncoder<Message> {
    private static final List<MediaType> streamingMediaTypes = Arrays.stream(MIME_TYPES).map(mimeType -> new MediaType(mimeType.getType(), mimeType.getSubtype(), Collections.singletonMap("delimited", "true"))).toList();

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return Message.class.isAssignableFrom(elementType.toClass()) && this.supportsMimeType(mimeType);
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<? extends Message> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.from(inputStream).map(message2 -> this.encodeValue((Message)message2, bufferFactory, !(inputStream instanceof Mono)));
    }

    @Override
    public DataBuffer encodeValue(Message message2, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return this.encodeValue(message2, bufferFactory, false);
    }

    private DataBuffer encodeValue(Message message2, DataBufferFactory bufferFactory, boolean delimited) {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        try {
            if (delimited) {
                message2.writeDelimitedTo((OutputStream)bos);
            } else {
                message2.writeTo((OutputStream)bos);
            }
            byte[] bytes = bos.toByteArrayUnsafe();
            return bufferFactory.wrap(bytes);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unexpected I/O error while writing to data buffer", ex);
        }
    }

    @Override
    public List<MediaType> getStreamingMediaTypes() {
        return streamingMediaTypes;
    }

    @Override
    public List<MimeType> getEncodableMimeTypes() {
        return this.getMimeTypes();
    }
}

