/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task.support;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureTask;

public class TaskExecutorAdapter
implements AsyncListenableTaskExecutor {
    private final Executor concurrentExecutor;
    @Nullable
    private TaskDecorator taskDecorator;

    public TaskExecutorAdapter(Executor concurrentExecutor) {
        Assert.notNull((Object)concurrentExecutor, "Executor must not be null");
        this.concurrentExecutor = concurrentExecutor;
    }

    public final void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    @Override
    public void execute(Runnable task2) {
        try {
            this.doExecute(this.concurrentExecutor, this.taskDecorator, task2);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(this.concurrentExecutor, task2, ex);
        }
    }

    @Override
    public Future<?> submit(Runnable task2) {
        try {
            Executor executor;
            if (this.taskDecorator == null && (executor = this.concurrentExecutor) instanceof ExecutorService) {
                ExecutorService executorService = (ExecutorService)executor;
                return executorService.submit(task2);
            }
            FutureTask<Object> future = new FutureTask<Object>(task2, null);
            this.doExecute(this.concurrentExecutor, this.taskDecorator, future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(this.concurrentExecutor, task2, ex);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task2) {
        try {
            Executor executor;
            if (this.taskDecorator == null && (executor = this.concurrentExecutor) instanceof ExecutorService) {
                ExecutorService executorService = (ExecutorService)executor;
                return executorService.submit(task2);
            }
            FutureTask<T> future = new FutureTask<T>(task2);
            this.doExecute(this.concurrentExecutor, this.taskDecorator, future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(this.concurrentExecutor, task2, ex);
        }
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task2) {
        try {
            ListenableFutureTask<Object> future = new ListenableFutureTask<Object>(task2, null);
            this.doExecute(this.concurrentExecutor, this.taskDecorator, future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(this.concurrentExecutor, task2, ex);
        }
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> task2) {
        try {
            ListenableFutureTask<T> future = new ListenableFutureTask<T>(task2);
            this.doExecute(this.concurrentExecutor, this.taskDecorator, future);
            return future;
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException(this.concurrentExecutor, task2, ex);
        }
    }

    protected void doExecute(Executor concurrentExecutor, @Nullable TaskDecorator taskDecorator, Runnable runnable) throws RejectedExecutionException {
        concurrentExecutor.execute(taskDecorator != null ? taskDecorator.decorate(runnable) : runnable);
    }
}

