/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.task;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.core.task.VirtualThreadDelegate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrencyThrottleSupport;
import org.springframework.util.CustomizableThreadCreator;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureTask;

public class SimpleAsyncTaskExecutor
extends CustomizableThreadCreator
implements AsyncListenableTaskExecutor,
Serializable,
AutoCloseable {
    public static final int UNBOUNDED_CONCURRENCY = -1;
    public static final int NO_CONCURRENCY = 0;
    private final ConcurrencyThrottleAdapter concurrencyThrottle = new ConcurrencyThrottleAdapter();
    @Nullable
    private VirtualThreadDelegate virtualThreadDelegate;
    @Nullable
    private ThreadFactory threadFactory;
    @Nullable
    private TaskDecorator taskDecorator;
    private long taskTerminationTimeout;
    @Nullable
    private Set<Thread> activeThreads;
    private volatile boolean active = true;

    public SimpleAsyncTaskExecutor() {
    }

    public SimpleAsyncTaskExecutor(String threadNamePrefix) {
        super(threadNamePrefix);
    }

    public SimpleAsyncTaskExecutor(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void setVirtualThreads(boolean virtual) {
        this.virtualThreadDelegate = virtual ? new VirtualThreadDelegate() : null;
    }

    public void setThreadFactory(@Nullable ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Nullable
    public final ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    public void setTaskTerminationTimeout(long timeout) {
        Assert.isTrue(timeout >= 0L, "Timeout value must be >=0");
        this.taskTerminationTimeout = timeout;
        this.activeThreads = timeout > 0L ? ConcurrentHashMap.newKeySet() : null;
    }

    public void setConcurrencyLimit(int concurrencyLimit) {
        this.concurrencyThrottle.setConcurrencyLimit(concurrencyLimit);
    }

    public final int getConcurrencyLimit() {
        return this.concurrencyThrottle.getConcurrencyLimit();
    }

    public final boolean isThrottleActive() {
        return this.concurrencyThrottle.isThrottleActive();
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void execute(Runnable task2) {
        this.execute(task2, Long.MAX_VALUE);
    }

    @Override
    @Deprecated
    public void execute(Runnable task2, long startTimeout) {
        Runnable taskToUse;
        Assert.notNull((Object)task2, "Runnable must not be null");
        if (!this.isActive()) {
            throw new TaskRejectedException(this.getClass().getSimpleName() + " has been closed already");
        }
        Runnable runnable = taskToUse = this.taskDecorator != null ? this.taskDecorator.decorate(task2) : task2;
        if (this.isThrottleActive() && startTimeout > 0L) {
            this.concurrencyThrottle.beforeAccess();
            this.doExecute(new TaskTrackingRunnable(taskToUse));
        } else if (this.activeThreads != null) {
            this.doExecute(new TaskTrackingRunnable(taskToUse));
        } else {
            this.doExecute(taskToUse);
        }
    }

    @Override
    public Future<?> submit(Runnable task2) {
        FutureTask<Object> future = new FutureTask<Object>(task2, null);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task2) {
        FutureTask<T> future = new FutureTask<T>(task2);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task2) {
        ListenableFutureTask<Object> future = new ListenableFutureTask<Object>(task2, null);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> task2) {
        ListenableFutureTask<T> future = new ListenableFutureTask<T>(task2);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    protected void doExecute(Runnable task2) {
        this.newThread(task2).start();
    }

    protected Thread newThread(Runnable task2) {
        if (this.virtualThreadDelegate != null) {
            return this.virtualThreadDelegate.newVirtualThread(this.nextThreadName(), task2);
        }
        return this.threadFactory != null ? this.threadFactory.newThread(task2) : this.createThread(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.active) {
            this.active = false;
            Set<Thread> threads = this.activeThreads;
            if (threads != null) {
                threads.forEach(Thread::interrupt);
                Set<Thread> set = threads;
                synchronized (set) {
                    try {
                        if (!threads.isEmpty()) {
                            threads.wait(this.taskTerminationTimeout);
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    private static class ConcurrencyThrottleAdapter
    extends ConcurrencyThrottleSupport {
        private ConcurrencyThrottleAdapter() {
        }

        @Override
        protected void beforeAccess() {
            super.beforeAccess();
        }

        @Override
        protected void afterAccess() {
            super.afterAccess();
        }
    }

    private class TaskTrackingRunnable
    implements Runnable {
        private final Runnable task;

        public TaskTrackingRunnable(Runnable task2) {
            Assert.notNull((Object)task2, "Task must not be null");
            this.task = task2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set<Thread> threads = SimpleAsyncTaskExecutor.this.activeThreads;
            Thread thread2 = null;
            if (threads != null) {
                thread2 = Thread.currentThread();
                threads.add(thread2);
            }
            try {
                this.task.run();
            }
            finally {
                if (threads != null) {
                    threads.remove(thread2);
                    if (!SimpleAsyncTaskExecutor.this.isActive()) {
                        Set<Thread> set = threads;
                        synchronized (set) {
                            if (threads.isEmpty()) {
                                threads.notify();
                            }
                        }
                    }
                }
                SimpleAsyncTaskExecutor.this.concurrencyThrottle.afterAccess();
            }
        }
    }
}

