/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ApplicationListenerDetector;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.StartupStep;
import org.springframework.lang.Nullable;

final class PostProcessorRegistrationDelegate {
    private PostProcessorRegistrationDelegate() {
    }

    public static void invokeBeanFactoryPostProcessors(ConfigurableListableBeanFactory beanFactory, List<BeanFactoryPostProcessor> beanFactoryPostProcessors) {
        HashSet<String> processedBeans = new HashSet<String>();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            String[] postProcessorNames;
            String[] registryProcessor;
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)((Object)beanFactory);
            ArrayList<BeanFactoryPostProcessor> regularPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
            ArrayList<Object> registryProcessors = new ArrayList<Object>();
            for (BeanFactoryPostProcessor postProcessor : beanFactoryPostProcessors) {
                if (postProcessor instanceof BeanDefinitionRegistryPostProcessor) {
                    registryProcessor = (String[])postProcessor;
                    registryProcessor.postProcessBeanDefinitionRegistry(registry);
                    registryProcessors.add(registryProcessor);
                    continue;
                }
                regularPostProcessors.add(postProcessor);
            }
            ArrayList<BeanDefinitionRegistryPostProcessor> currentRegistryProcessors = new ArrayList<BeanDefinitionRegistryPostProcessor>();
            for (String ppName : postProcessorNames = beanFactory.getBeanNamesForType(BeanDefinitionRegistryPostProcessor.class, true, false)) {
                if (!beanFactory.isTypeMatch(ppName, PriorityOrdered.class)) continue;
                currentRegistryProcessors.add(beanFactory.getBean(ppName, BeanDefinitionRegistryPostProcessor.class));
                processedBeans.add(ppName);
            }
            PostProcessorRegistrationDelegate.sortPostProcessors(currentRegistryProcessors, beanFactory);
            registryProcessors.addAll(currentRegistryProcessors);
            PostProcessorRegistrationDelegate.invokeBeanDefinitionRegistryPostProcessors(currentRegistryProcessors, registry, beanFactory.getApplicationStartup());
            currentRegistryProcessors.clear();
            registryProcessor = postProcessorNames = beanFactory.getBeanNamesForType(BeanDefinitionRegistryPostProcessor.class, true, false);
            int n = registryProcessor.length;
            for (int j = 0; j < n; ++j) {
                String ppName;
                ppName = registryProcessor[j];
                if (processedBeans.contains(ppName) || !beanFactory.isTypeMatch(ppName, Ordered.class)) continue;
                currentRegistryProcessors.add(beanFactory.getBean(ppName, BeanDefinitionRegistryPostProcessor.class));
                processedBeans.add(ppName);
            }
            PostProcessorRegistrationDelegate.sortPostProcessors(currentRegistryProcessors, beanFactory);
            registryProcessors.addAll(currentRegistryProcessors);
            PostProcessorRegistrationDelegate.invokeBeanDefinitionRegistryPostProcessors(currentRegistryProcessors, registry, beanFactory.getApplicationStartup());
            currentRegistryProcessors.clear();
            int reiterate = 1;
            while (reiterate != 0) {
                reiterate = 0;
                for (String ppName : postProcessorNames = beanFactory.getBeanNamesForType(BeanDefinitionRegistryPostProcessor.class, true, false)) {
                    if (processedBeans.contains(ppName)) continue;
                    currentRegistryProcessors.add(beanFactory.getBean(ppName, BeanDefinitionRegistryPostProcessor.class));
                    processedBeans.add(ppName);
                    reiterate = 1;
                }
                PostProcessorRegistrationDelegate.sortPostProcessors(currentRegistryProcessors, beanFactory);
                registryProcessors.addAll(currentRegistryProcessors);
                PostProcessorRegistrationDelegate.invokeBeanDefinitionRegistryPostProcessors(currentRegistryProcessors, registry, beanFactory.getApplicationStartup());
                currentRegistryProcessors.clear();
            }
            PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(registryProcessors, beanFactory);
            PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(regularPostProcessors, beanFactory);
        } else {
            PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(beanFactoryPostProcessors, beanFactory);
        }
        String[] postProcessorNames = beanFactory.getBeanNamesForType(BeanFactoryPostProcessor.class, true, false);
        ArrayList<BeanFactoryPostProcessor> priorityOrderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        for (String ppName : postProcessorNames) {
            if (processedBeans.contains(ppName)) continue;
            if (beanFactory.isTypeMatch(ppName, PriorityOrdered.class)) {
                priorityOrderedPostProcessors.add(beanFactory.getBean(ppName, BeanFactoryPostProcessor.class));
                continue;
            }
            if (beanFactory.isTypeMatch(ppName, Ordered.class)) {
                orderedPostProcessorNames.add(ppName);
                continue;
            }
            nonOrderedPostProcessorNames.add(ppName);
        }
        PostProcessorRegistrationDelegate.sortPostProcessors(priorityOrderedPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(priorityOrderedPostProcessors, beanFactory);
        ArrayList<BeanFactoryPostProcessor> orderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>(orderedPostProcessorNames.size());
        for (String postProcessorName : orderedPostProcessorNames) {
            orderedPostProcessors.add(beanFactory.getBean(postProcessorName, BeanFactoryPostProcessor.class));
        }
        PostProcessorRegistrationDelegate.sortPostProcessors(orderedPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(orderedPostProcessors, beanFactory);
        ArrayList<BeanFactoryPostProcessor> nonOrderedPostProcessors = new ArrayList<BeanFactoryPostProcessor>(nonOrderedPostProcessorNames.size());
        for (String postProcessorName : nonOrderedPostProcessorNames) {
            nonOrderedPostProcessors.add(beanFactory.getBean(postProcessorName, BeanFactoryPostProcessor.class));
        }
        PostProcessorRegistrationDelegate.invokeBeanFactoryPostProcessors(nonOrderedPostProcessors, beanFactory);
        beanFactory.clearMetadataCache();
    }

    public static void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, AbstractApplicationContext applicationContext) {
        BeanPostProcessor pp;
        String[] postProcessorNames = beanFactory.getBeanNamesForType(BeanPostProcessor.class, true, false);
        int beanProcessorTargetCount = beanFactory.getBeanPostProcessorCount() + 1 + postProcessorNames.length;
        beanFactory.addBeanPostProcessor(new BeanPostProcessorChecker(beanFactory, postProcessorNames, beanProcessorTargetCount));
        ArrayList<BeanPostProcessor> priorityOrderedPostProcessors = new ArrayList<BeanPostProcessor>();
        ArrayList<BeanPostProcessor> internalPostProcessors = new ArrayList<BeanPostProcessor>();
        ArrayList<String> orderedPostProcessorNames = new ArrayList<String>();
        ArrayList<String> nonOrderedPostProcessorNames = new ArrayList<String>();
        for (String ppName : postProcessorNames) {
            if (beanFactory.isTypeMatch(ppName, PriorityOrdered.class)) {
                pp = beanFactory.getBean(ppName, BeanPostProcessor.class);
                priorityOrderedPostProcessors.add(pp);
                if (!(pp instanceof MergedBeanDefinitionPostProcessor)) continue;
                internalPostProcessors.add(pp);
                continue;
            }
            if (beanFactory.isTypeMatch(ppName, Ordered.class)) {
                orderedPostProcessorNames.add(ppName);
                continue;
            }
            nonOrderedPostProcessorNames.add(ppName);
        }
        PostProcessorRegistrationDelegate.sortPostProcessors(priorityOrderedPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, priorityOrderedPostProcessors);
        ArrayList<BeanPostProcessor> orderedPostProcessors = new ArrayList<BeanPostProcessor>(orderedPostProcessorNames.size());
        for (String ppName : orderedPostProcessorNames) {
            BeanPostProcessor pp2 = beanFactory.getBean(ppName, BeanPostProcessor.class);
            orderedPostProcessors.add(pp2);
            if (!(pp2 instanceof MergedBeanDefinitionPostProcessor)) continue;
            internalPostProcessors.add(pp2);
        }
        PostProcessorRegistrationDelegate.sortPostProcessors(orderedPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, orderedPostProcessors);
        ArrayList<BeanPostProcessor> nonOrderedPostProcessors = new ArrayList<BeanPostProcessor>(nonOrderedPostProcessorNames.size());
        for (String ppName : nonOrderedPostProcessorNames) {
            pp = beanFactory.getBean(ppName, BeanPostProcessor.class);
            nonOrderedPostProcessors.add(pp);
            if (!(pp instanceof MergedBeanDefinitionPostProcessor)) continue;
            internalPostProcessors.add(pp);
        }
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, nonOrderedPostProcessors);
        PostProcessorRegistrationDelegate.sortPostProcessors(internalPostProcessors, beanFactory);
        PostProcessorRegistrationDelegate.registerBeanPostProcessors(beanFactory, internalPostProcessors);
        beanFactory.addBeanPostProcessor(new ApplicationListenerDetector(applicationContext));
    }

    static <T extends BeanPostProcessor> List<T> loadBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, Class<T> beanPostProcessorType) {
        String[] postProcessorNames = beanFactory.getBeanNamesForType(beanPostProcessorType, true, false);
        ArrayList<BeanPostProcessor> postProcessors = new ArrayList<BeanPostProcessor>();
        for (String ppName : postProcessorNames) {
            postProcessors.add((BeanPostProcessor)beanFactory.getBean(ppName, beanPostProcessorType));
        }
        PostProcessorRegistrationDelegate.sortPostProcessors(postProcessors, beanFactory);
        return postProcessors;
    }

    static void invokeMergedBeanDefinitionPostProcessors(DefaultListableBeanFactory beanFactory) {
        new MergedBeanDefinitionPostProcessorInvoker(beanFactory).invokeMergedBeanDefinitionPostProcessors();
    }

    private static void sortPostProcessors(List<?> postProcessors, ConfigurableListableBeanFactory beanFactory) {
        if (postProcessors.size() <= 1) {
            return;
        }
        Comparator<Object> comparatorToUse = null;
        if (beanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory dlbf = (DefaultListableBeanFactory)beanFactory;
            comparatorToUse = dlbf.getDependencyComparator();
        }
        if (comparatorToUse == null) {
            comparatorToUse = OrderComparator.INSTANCE;
        }
        postProcessors.sort(comparatorToUse);
    }

    private static void invokeBeanDefinitionRegistryPostProcessors(Collection<? extends BeanDefinitionRegistryPostProcessor> postProcessors, BeanDefinitionRegistry registry, ApplicationStartup applicationStartup) {
        for (BeanDefinitionRegistryPostProcessor beanDefinitionRegistryPostProcessor : postProcessors) {
            StartupStep postProcessBeanDefRegistry = applicationStartup.start("spring.context.beandef-registry.post-process").tag("postProcessor", beanDefinitionRegistryPostProcessor::toString);
            beanDefinitionRegistryPostProcessor.postProcessBeanDefinitionRegistry(registry);
            postProcessBeanDefRegistry.end();
        }
    }

    private static void invokeBeanFactoryPostProcessors(Collection<? extends BeanFactoryPostProcessor> postProcessors, ConfigurableListableBeanFactory beanFactory) {
        for (BeanFactoryPostProcessor beanFactoryPostProcessor : postProcessors) {
            StartupStep postProcessBeanFactory = beanFactory.getApplicationStartup().start("spring.context.bean-factory.post-process").tag("postProcessor", beanFactoryPostProcessor::toString);
            beanFactoryPostProcessor.postProcessBeanFactory(beanFactory);
            postProcessBeanFactory.end();
        }
    }

    private static void registerBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, List<? extends BeanPostProcessor> postProcessors) {
        if (beanFactory instanceof AbstractBeanFactory) {
            AbstractBeanFactory abstractBeanFactory = (AbstractBeanFactory)((Object)beanFactory);
            abstractBeanFactory.addBeanPostProcessors(postProcessors);
        } else {
            for (BeanPostProcessor beanPostProcessor : postProcessors) {
                beanFactory.addBeanPostProcessor(beanPostProcessor);
            }
        }
    }

    private static final class BeanPostProcessorChecker
    implements BeanPostProcessor {
        private static final Log logger = LogFactory.getLog(BeanPostProcessorChecker.class);
        private final ConfigurableListableBeanFactory beanFactory;
        private final String[] postProcessorNames;
        private final int beanPostProcessorTargetCount;

        public BeanPostProcessorChecker(ConfigurableListableBeanFactory beanFactory, String[] postProcessorNames, int beanPostProcessorTargetCount) {
            this.beanFactory = beanFactory;
            this.postProcessorNames = postProcessorNames;
            this.beanPostProcessorTargetCount = beanPostProcessorTargetCount;
        }

        @Override
        public Object postProcessBeforeInitialization(Object bean2, String beanName) {
            return bean2;
        }

        @Override
        public Object postProcessAfterInitialization(Object bean2, String beanName) {
            if (!(bean2 instanceof BeanPostProcessor) && !this.isInfrastructureBean(beanName) && this.beanFactory.getBeanPostProcessorCount() < this.beanPostProcessorTargetCount && logger.isWarnEnabled()) {
                String bppName;
                LinkedHashSet<String> bppsInCreation = new LinkedHashSet<String>(2);
                for (String bppName2 : this.postProcessorNames) {
                    if (!this.beanFactory.isCurrentlyInCreation(bppName2)) continue;
                    bppsInCreation.add(bppName2);
                }
                if (bppsInCreation.size() == 1 && this.beanFactory.containsBeanDefinition(bppName = (String)bppsInCreation.iterator().next()) && beanName.equals(this.beanFactory.getBeanDefinition(bppName).getFactoryBeanName())) {
                    logger.warn("Bean '" + beanName + "' of type [" + bean2.getClass().getName() + "] is not eligible for getting processed by all BeanPostProcessors (for example: not eligible for auto-proxying). The currently created BeanPostProcessor " + bppsInCreation + " is declared through a non-static factory method on that class; consider declaring it as static instead.");
                    return bean2;
                }
                logger.warn("Bean '" + beanName + "' of type [" + bean2.getClass().getName() + "] is not eligible for getting processed by all BeanPostProcessors (for example: not eligible for auto-proxying). Is this bean getting eagerly injected/applied to a currently created BeanPostProcessor " + bppsInCreation + "? Check the corresponding BeanPostProcessor declaration and its dependencies/advisors. If this bean does not have to be post-processed, declare it with ROLE_INFRASTRUCTURE.");
            }
            return bean2;
        }

        private boolean isInfrastructureBean(@Nullable String beanName) {
            if (beanName != null && this.beanFactory.containsBeanDefinition(beanName)) {
                BeanDefinition bd = this.beanFactory.getBeanDefinition(beanName);
                return bd.getRole() == 2;
            }
            return false;
        }
    }

    private static final class MergedBeanDefinitionPostProcessorInvoker {
        private final DefaultListableBeanFactory beanFactory;

        private MergedBeanDefinitionPostProcessorInvoker(DefaultListableBeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        private void invokeMergedBeanDefinitionPostProcessors() {
            List<MergedBeanDefinitionPostProcessor> postProcessors = PostProcessorRegistrationDelegate.loadBeanPostProcessors(this.beanFactory, MergedBeanDefinitionPostProcessor.class);
            for (String beanName : this.beanFactory.getBeanDefinitionNames()) {
                RootBeanDefinition bd = (RootBeanDefinition)this.beanFactory.getMergedBeanDefinition(beanName);
                Class<?> beanType = this.resolveBeanType(bd);
                this.postProcessRootBeanDefinition(postProcessors, beanName, beanType, bd);
                bd.markAsPostProcessed();
            }
            PostProcessorRegistrationDelegate.registerBeanPostProcessors((ConfigurableListableBeanFactory)this.beanFactory, postProcessors);
        }

        private void postProcessRootBeanDefinition(List<MergedBeanDefinitionPostProcessor> postProcessors, String beanName, Class<?> beanType, RootBeanDefinition bd) {
            BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, bd);
            postProcessors.forEach(postProcessor -> postProcessor.postProcessMergedBeanDefinition(bd, beanType, beanName));
            for (PropertyValue propertyValue : bd.getPropertyValues().getPropertyValueList()) {
                this.postProcessValue(postProcessors, valueResolver, propertyValue.getValue());
            }
            for (ConstructorArgumentValues.ValueHolder valueHolder : bd.getConstructorArgumentValues().getIndexedArgumentValues().values()) {
                this.postProcessValue(postProcessors, valueResolver, valueHolder.getValue());
            }
            for (ConstructorArgumentValues.ValueHolder valueHolder : bd.getConstructorArgumentValues().getGenericArgumentValues()) {
                this.postProcessValue(postProcessors, valueResolver, valueHolder.getValue());
            }
        }

        private void postProcessValue(List<MergedBeanDefinitionPostProcessor> postProcessors, BeanDefinitionValueResolver valueResolver, @Nullable Object value) {
            BeanDefinitionHolder bdh;
            BeanDefinition beanDefinition;
            if (value instanceof BeanDefinitionHolder && (beanDefinition = (bdh = (BeanDefinitionHolder)value).getBeanDefinition()) instanceof AbstractBeanDefinition) {
                AbstractBeanDefinition innerBd = (AbstractBeanDefinition)beanDefinition;
                innerBeanType = this.resolveBeanType(innerBd);
                this.resolveInnerBeanDefinition(valueResolver, innerBd, (innerBeanName, innerBeanDefinition) -> this.postProcessRootBeanDefinition(postProcessors, (String)innerBeanName, innerBeanType, (RootBeanDefinition)innerBeanDefinition));
            } else if (value instanceof AbstractBeanDefinition) {
                AbstractBeanDefinition innerBd = (AbstractBeanDefinition)value;
                innerBeanType = this.resolveBeanType(innerBd);
                this.resolveInnerBeanDefinition(valueResolver, innerBd, (innerBeanName, innerBeanDefinition) -> this.postProcessRootBeanDefinition(postProcessors, (String)innerBeanName, innerBeanType, (RootBeanDefinition)innerBeanDefinition));
            } else if (value instanceof TypedStringValue) {
                TypedStringValue typedStringValue = (TypedStringValue)value;
                this.resolveTypeStringValue(typedStringValue);
            }
        }

        private void resolveInnerBeanDefinition(BeanDefinitionValueResolver valueResolver, BeanDefinition innerBeanDefinition, BiConsumer<String, RootBeanDefinition> resolver) {
            valueResolver.resolveInnerBean(null, innerBeanDefinition, (name, rbd) -> {
                resolver.accept((String)name, (RootBeanDefinition)rbd);
                return Void.class;
            });
        }

        private void resolveTypeStringValue(TypedStringValue typedStringValue) {
            try {
                typedStringValue.resolveTargetType(this.beanFactory.getBeanClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        private Class<?> resolveBeanType(AbstractBeanDefinition bd) {
            if (!bd.hasBeanClass()) {
                try {
                    bd.resolveBeanClass(this.beanFactory.getBeanClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return bd.getResolvableType().toClass();
        }
    }
}

