/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

final class CacheOperationSourcePointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    @Nullable
    private CacheOperationSource cacheOperationSource;

    public CacheOperationSourcePointcut() {
        this.setClassFilter(new CacheOperationSourceClassFilter());
    }

    public void setCacheOperationSource(@Nullable CacheOperationSource cacheOperationSource) {
        this.cacheOperationSource = cacheOperationSource;
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        return this.cacheOperationSource == null || this.cacheOperationSource.hasCacheOperations(method, targetClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof CacheOperationSourcePointcut)) return false;
        CacheOperationSourcePointcut that = (CacheOperationSourcePointcut)other;
        if (!ObjectUtils.nullSafeEquals(this.cacheOperationSource, that.cacheOperationSource)) return false;
        return true;
    }

    public int hashCode() {
        return CacheOperationSourcePointcut.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.cacheOperationSource;
    }

    private final class CacheOperationSourceClassFilter
    implements ClassFilter {
        private CacheOperationSourceClassFilter() {
        }

        @Override
        public boolean matches(Class<?> clazz) {
            if (CacheManager.class.isAssignableFrom(clazz)) {
                return false;
            }
            return CacheOperationSourcePointcut.this.cacheOperationSource == null || CacheOperationSourcePointcut.this.cacheOperationSource.isCandidateClass(clazz);
        }

        @Nullable
        private CacheOperationSource getCacheOperationSource() {
            return CacheOperationSourcePointcut.this.cacheOperationSource;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof CacheOperationSourceClassFilter)) return false;
            CacheOperationSourceClassFilter that = (CacheOperationSourceClassFilter)other;
            if (!ObjectUtils.nullSafeEquals(this.getCacheOperationSource(), that.getCacheOperationSource())) return false;
            return true;
        }

        public int hashCode() {
            return CacheOperationSourceClassFilter.class.hashCode();
        }

        public String toString() {
            return CacheOperationSourceClassFilter.class.getName() + ": " + this.getCacheOperationSource();
        }
    }
}

