/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.reactive.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.validation.method.MethodValidationResult;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;

public class DefaultErrorAttributes
implements ErrorAttributes {
    private static final String ERROR_INTERNAL_ATTRIBUTE = DefaultErrorAttributes.class.getName() + ".ERROR";

    @Override
    public Map<String, Object> getErrorAttributes(ServerRequest request, ErrorAttributeOptions options) {
        Map<String, Object> errorAttributes = this.getErrorAttributes(request, options.isIncluded(ErrorAttributeOptions.Include.STACK_TRACE));
        options.retainIncluded(errorAttributes);
        return errorAttributes;
    }

    private Map<String, Object> getErrorAttributes(ServerRequest request, boolean includeStackTrace) {
        LinkedHashMap<String, Object> errorAttributes = new LinkedHashMap<String, Object>();
        errorAttributes.put("timestamp", new Date());
        errorAttributes.put("path", request.requestPath().value());
        Throwable error = this.getError(request);
        MergedAnnotation<ResponseStatus> responseStatusAnnotation = MergedAnnotations.from(error.getClass(), MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(ResponseStatus.class);
        HttpStatus errorStatus = this.determineHttpStatus(error, responseStatusAnnotation);
        errorAttributes.put("status", errorStatus.value());
        errorAttributes.put("error", errorStatus.getReasonPhrase());
        errorAttributes.put("requestId", request.exchange().getRequest().getId());
        this.handleException(errorAttributes, error, responseStatusAnnotation, includeStackTrace);
        return errorAttributes;
    }

    private HttpStatus determineHttpStatus(Throwable error, MergedAnnotation<ResponseStatus> responseStatusAnnotation) {
        ResponseStatusException responseStatusException;
        HttpStatus httpStatus;
        if (error instanceof ResponseStatusException && (httpStatus = HttpStatus.resolve((responseStatusException = (ResponseStatusException)error).getStatusCode().value())) != null) {
            return httpStatus;
        }
        return responseStatusAnnotation.getValue("code", HttpStatus.class).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private void addStackTrace(Map<String, Object> errorAttributes, Throwable error) {
        StringWriter stackTrace = new StringWriter();
        error.printStackTrace(new PrintWriter(stackTrace));
        stackTrace.flush();
        errorAttributes.put("trace", stackTrace.toString());
    }

    private void handleException(Map<String, Object> errorAttributes, Throwable error, MergedAnnotation<ResponseStatus> responseStatusAnnotation, boolean includeStackTrace) {
        Throwable exception;
        if (error instanceof BindingResult) {
            BindingResult bindingResult = (BindingResult)((Object)error);
            errorAttributes.put("message", error.getMessage());
            errorAttributes.put("errors", bindingResult.getAllErrors());
            exception = error;
        } else if (error instanceof MethodValidationResult) {
            MethodValidationResult methodValidationResult = (MethodValidationResult)((Object)error);
            this.addMessageAndErrorsFromMethodValidationResult(errorAttributes, methodValidationResult);
            exception = error;
        } else if (error instanceof ResponseStatusException) {
            ResponseStatusException responseStatusException = (ResponseStatusException)error;
            errorAttributes.put("message", responseStatusException.getReason());
            Throwable throwable = exception = responseStatusException.getCause() != null ? responseStatusException.getCause() : error;
            if (exception instanceof BindingResult) {
                BindingResult bindingResult = (BindingResult)((Object)exception);
                errorAttributes.put("errors", bindingResult.getAllErrors());
            }
        } else {
            exception = error;
            String reason = responseStatusAnnotation.getValue("reason", String.class).orElse("");
            String message2 = StringUtils.hasText(reason) ? reason : error.getMessage();
            errorAttributes.put("message", message2 != null ? message2 : "");
        }
        errorAttributes.put("exception", exception.getClass().getName());
        if (includeStackTrace) {
            this.addStackTrace(errorAttributes, exception);
        }
    }

    private void addMessageAndErrorsFromMethodValidationResult(Map<String, Object> errorAttributes, MethodValidationResult result) {
        List<ObjectError> errors = result.getAllErrors().stream().filter(ObjectError.class::isInstance).map(ObjectError.class::cast).toList();
        errorAttributes.put("message", "Validation failed for method='" + result.getMethod() + "'. Error count: " + errors.size());
        errorAttributes.put("errors", errors);
    }

    @Override
    public Throwable getError(ServerRequest request) {
        Optional error = request.attribute(ERROR_INTERNAL_ATTRIBUTE);
        return (Throwable)error.orElseThrow(() -> new IllegalStateException("Missing exception attribute in ServerWebExchange"));
    }

    @Override
    public void storeErrorInformation(Throwable error, ServerWebExchange exchange2) {
        exchange2.getAttributes().putIfAbsent(ERROR_INTERNAL_ATTRIBUTE, error);
    }
}

