/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.context;

import java.io.File;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.system.SystemProperties;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class WebServerPortFileWriter
implements ApplicationListener<WebServerInitializedEvent> {
    private static final String DEFAULT_FILE_NAME = "application.port";
    private static final String[] PROPERTY_VARIABLES = new String[]{"PORTFILE", "portfile"};
    private static final Log logger = LogFactory.getLog(WebServerPortFileWriter.class);
    private final File file;

    public WebServerPortFileWriter() {
        this(new File(DEFAULT_FILE_NAME));
    }

    public WebServerPortFileWriter(String filename) {
        this(new File(filename));
    }

    public WebServerPortFileWriter(File file) {
        Assert.notNull((Object)file, "File must not be null");
        String override = SystemProperties.get(PROPERTY_VARIABLES);
        this.file = override != null ? new File(override) : file;
    }

    @Override
    public void onApplicationEvent(WebServerInitializedEvent event) {
        File portFile = this.getPortFile(event.getApplicationContext());
        try {
            String port = String.valueOf(event.getWebServer().getPort());
            this.createParentDirectory(portFile);
            FileCopyUtils.copy(port.getBytes(), portFile);
            portFile.deleteOnExit();
        }
        catch (Exception ex) {
            logger.warn(LogMessage.format("Cannot create port file %s", (Object)this.file));
        }
    }

    protected File getPortFile(ApplicationContext applicationContext) {
        String namespace = this.getServerNamespace(applicationContext);
        if (!StringUtils.hasLength(namespace)) {
            return this.file;
        }
        String filename = this.file.getName();
        String extension = StringUtils.getFilenameExtension(filename);
        String filenameWithoutExtension = extension != null ? filename.substring(0, filename.length() - extension.length() - 1) : filename;
        String suffix = !this.isUpperCase(filename) ? namespace.toLowerCase(Locale.ENGLISH) : namespace.toUpperCase(Locale.ENGLISH);
        return new File(this.file.getParentFile(), filenameWithoutExtension + "-" + suffix + (String)(!StringUtils.hasLength(extension) ? "" : "." + extension));
    }

    private String getServerNamespace(ApplicationContext applicationContext) {
        if (applicationContext instanceof WebServerApplicationContext) {
            WebServerApplicationContext webServerApplicationContext = (WebServerApplicationContext)applicationContext;
            return webServerApplicationContext.getServerNamespace();
        }
        return null;
    }

    private boolean isUpperCase(String name) {
        for (int i2 = 0; i2 < name.length(); ++i2) {
            if (!Character.isLetter(name.charAt(i2)) || Character.isUpperCase(name.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private void createParentDirectory(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
    }
}

