/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import org.springframework.boot.web.client.RootUriTemplateHandler;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplateHandler;

public class RootUriBuilderFactory
extends RootUriTemplateHandler
implements UriBuilderFactory {
    RootUriBuilderFactory(String rootUri, UriTemplateHandler delegate) {
        super(rootUri, delegate);
    }

    @Override
    public UriBuilder uriString(String uriTemplate) {
        return UriComponentsBuilder.fromUriString(this.apply(uriTemplate));
    }

    @Override
    public UriBuilder builder() {
        return UriComponentsBuilder.newInstance();
    }

    static void applyTo(RestTemplate restTemplate, String rootUri) {
        Assert.notNull((Object)restTemplate, "RestTemplate must not be null");
        RootUriBuilderFactory handler = new RootUriBuilderFactory(rootUri, restTemplate.getUriTemplateHandler());
        restTemplate.setUriTemplateHandler(handler);
    }
}

