/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.task;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.task.SimpleAsyncTaskSchedulerCustomizer;
import org.springframework.scheduling.concurrent.SimpleAsyncTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SimpleAsyncTaskSchedulerBuilder {
    private final String threadNamePrefix;
    private final Integer concurrencyLimit;
    private final Boolean virtualThreads;
    private final Duration taskTerminationTimeout;
    private final Set<SimpleAsyncTaskSchedulerCustomizer> customizers;

    public SimpleAsyncTaskSchedulerBuilder() {
        this(null, null, null, null, null);
    }

    private SimpleAsyncTaskSchedulerBuilder(String threadNamePrefix, Integer concurrencyLimit, Boolean virtualThreads, Duration taskTerminationTimeout, Set<SimpleAsyncTaskSchedulerCustomizer> taskSchedulerCustomizers) {
        this.threadNamePrefix = threadNamePrefix;
        this.concurrencyLimit = concurrencyLimit;
        this.virtualThreads = virtualThreads;
        this.customizers = taskSchedulerCustomizers;
        this.taskTerminationTimeout = taskTerminationTimeout;
    }

    public SimpleAsyncTaskSchedulerBuilder threadNamePrefix(String threadNamePrefix) {
        return new SimpleAsyncTaskSchedulerBuilder(threadNamePrefix, this.concurrencyLimit, this.virtualThreads, this.taskTerminationTimeout, this.customizers);
    }

    public SimpleAsyncTaskSchedulerBuilder concurrencyLimit(Integer concurrencyLimit) {
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, concurrencyLimit, this.virtualThreads, this.taskTerminationTimeout, this.customizers);
    }

    public SimpleAsyncTaskSchedulerBuilder virtualThreads(Boolean virtualThreads) {
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, this.concurrencyLimit, virtualThreads, this.taskTerminationTimeout, this.customizers);
    }

    public SimpleAsyncTaskSchedulerBuilder taskTerminationTimeout(Duration taskTerminationTimeout) {
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, this.concurrencyLimit, this.virtualThreads, taskTerminationTimeout, this.customizers);
    }

    public SimpleAsyncTaskSchedulerBuilder customizers(SimpleAsyncTaskSchedulerCustomizer ... customizers) {
        Assert.notNull((Object)customizers, "Customizers must not be null");
        return this.customizers(Arrays.asList(customizers));
    }

    public SimpleAsyncTaskSchedulerBuilder customizers(Iterable<? extends SimpleAsyncTaskSchedulerCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, this.concurrencyLimit, this.virtualThreads, this.taskTerminationTimeout, this.append(null, customizers));
    }

    public SimpleAsyncTaskSchedulerBuilder additionalCustomizers(SimpleAsyncTaskSchedulerCustomizer ... customizers) {
        Assert.notNull((Object)customizers, "Customizers must not be null");
        return this.additionalCustomizers(Arrays.asList(customizers));
    }

    public SimpleAsyncTaskSchedulerBuilder additionalCustomizers(Iterable<? extends SimpleAsyncTaskSchedulerCustomizer> customizers) {
        Assert.notNull(customizers, "Customizers must not be null");
        return new SimpleAsyncTaskSchedulerBuilder(this.threadNamePrefix, this.concurrencyLimit, this.virtualThreads, this.taskTerminationTimeout, this.append(this.customizers, customizers));
    }

    public SimpleAsyncTaskScheduler build() {
        return this.configure(new SimpleAsyncTaskScheduler());
    }

    public <T extends SimpleAsyncTaskScheduler> T configure(T taskScheduler) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.threadNamePrefix).to(taskScheduler::setThreadNamePrefix);
        map.from(this.concurrencyLimit).to(taskScheduler::setConcurrencyLimit);
        map.from(this.virtualThreads).to(taskScheduler::setVirtualThreads);
        map.from(this.taskTerminationTimeout).as(Duration::toMillis).to(taskScheduler::setTaskTerminationTimeout);
        if (!CollectionUtils.isEmpty(this.customizers)) {
            this.customizers.forEach(customizer2 -> customizer2.customize(taskScheduler));
        }
        return taskScheduler;
    }

    private <T> Set<T> append(Set<T> set, Iterable<? extends T> additions) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(set != null ? set : Collections.emptySet());
        additions.forEach(result::add);
        return Collections.unmodifiableSet(result);
    }
}

