/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.boot.ssl.pem.PemContent;
import org.springframework.boot.ssl.pem.PemSslStore;
import org.springframework.boot.ssl.pem.PemSslStoreDetails;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.util.function.ThrowingSupplier;

final class LoadedPemSslStore
implements PemSslStore {
    private final PemSslStoreDetails details;
    private final ResourceLoader resourceLoader;
    private final Supplier<List<X509Certificate>> certificatesSupplier;
    private final Supplier<PrivateKey> privateKeySupplier;

    LoadedPemSslStore(PemSslStoreDetails details, ResourceLoader resourceLoader) {
        Assert.notNull((Object)details, "Details must not be null");
        Assert.notNull((Object)resourceLoader, "ResourceLoader must not be null");
        this.details = details;
        this.resourceLoader = resourceLoader;
        this.certificatesSupplier = LoadedPemSslStore.supplier(() -> LoadedPemSslStore.loadCertificates(details, resourceLoader));
        this.privateKeySupplier = LoadedPemSslStore.supplier(() -> LoadedPemSslStore.loadPrivateKey(details, resourceLoader));
    }

    private static <T> Supplier<T> supplier(ThrowingSupplier<T> supplier) {
        return SingletonSupplier.of(supplier.throwing(LoadedPemSslStore::asUncheckedIOException));
    }

    private static UncheckedIOException asUncheckedIOException(String message2, Exception cause) {
        return new UncheckedIOException(message2, (IOException)cause);
    }

    private static List<X509Certificate> loadCertificates(PemSslStoreDetails details, ResourceLoader resourceLoader) throws IOException {
        PemContent pemContent = PemContent.load(details.certificates(), resourceLoader);
        if (pemContent == null) {
            return null;
        }
        List<X509Certificate> certificates = pemContent.getCertificates();
        Assert.state(!CollectionUtils.isEmpty(certificates), "Loaded certificates are empty");
        return certificates;
    }

    private static PrivateKey loadPrivateKey(PemSslStoreDetails details, ResourceLoader resourceLoader) throws IOException {
        PemContent pemContent = PemContent.load(details.privateKey(), resourceLoader);
        return pemContent != null ? pemContent.getPrivateKey(details.privateKeyPassword()) : null;
    }

    @Override
    public String type() {
        return this.details.type();
    }

    @Override
    public String alias() {
        return this.details.alias();
    }

    @Override
    public String password() {
        return this.details.password();
    }

    @Override
    public List<X509Certificate> certificates() {
        return this.certificatesSupplier.get();
    }

    @Override
    public PrivateKey privateKey() {
        return this.privateKeySupplier.get();
    }

    @Override
    public PemSslStore withAlias(String alias) {
        return new LoadedPemSslStore(this.details.withAlias(alias), this.resourceLoader);
    }

    @Override
    public PemSslStore withPassword(String password) {
        return new LoadedPemSslStore(this.details.withPassword(password), this.resourceLoader);
    }
}

