/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ssl.NoSuchSslBundleException;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleRegistry;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;

public class DefaultSslBundleRegistry
implements SslBundleRegistry,
SslBundles {
    private static final Log logger = LogFactory.getLog(DefaultSslBundleRegistry.class);
    private final Map<String, RegisteredSslBundle> registeredBundles = new ConcurrentHashMap<String, RegisteredSslBundle>();

    public DefaultSslBundleRegistry() {
    }

    public DefaultSslBundleRegistry(String name, SslBundle bundle) {
        this.registerBundle(name, bundle);
    }

    @Override
    public void registerBundle(String name, SslBundle bundle) {
        Assert.notNull((Object)name, "Name must not be null");
        Assert.notNull((Object)bundle, "Bundle must not be null");
        RegisteredSslBundle previous = this.registeredBundles.putIfAbsent(name, new RegisteredSslBundle(name, bundle));
        Assert.state(previous == null, () -> "Cannot replace existing SSL bundle '%s'".formatted(name));
    }

    @Override
    public void updateBundle(String name, SslBundle updatedBundle) {
        this.getRegistered(name).update(updatedBundle);
    }

    @Override
    public SslBundle getBundle(String name) {
        return this.getRegistered(name).getBundle();
    }

    @Override
    public void addBundleUpdateHandler(String name, Consumer<SslBundle> updateHandler) throws NoSuchSslBundleException {
        this.getRegistered(name).addUpdateHandler(updateHandler);
    }

    @Override
    public List<String> getBundleNames() {
        ArrayList<String> names = new ArrayList<String>(this.registeredBundles.keySet());
        Collections.sort(names);
        return Collections.unmodifiableList(names);
    }

    private RegisteredSslBundle getRegistered(String name) throws NoSuchSslBundleException {
        Assert.notNull((Object)name, "Name must not be null");
        RegisteredSslBundle registered = this.registeredBundles.get(name);
        if (registered == null) {
            throw new NoSuchSslBundleException(name, "SSL bundle name '%s' cannot be found".formatted(name));
        }
        return registered;
    }

    private static class RegisteredSslBundle {
        private final String name;
        private final List<Consumer<SslBundle>> updateHandlers = new CopyOnWriteArrayList<Consumer<SslBundle>>();
        private volatile SslBundle bundle;

        RegisteredSslBundle(String name, SslBundle bundle) {
            this.name = name;
            this.bundle = bundle;
        }

        void update(SslBundle updatedBundle) {
            Assert.notNull((Object)updatedBundle, "UpdatedBundle must not be null");
            this.bundle = updatedBundle;
            if (this.updateHandlers.isEmpty()) {
                logger.warn(LogMessage.format("SSL bundle '%s' has been updated but may be in use by a technology that doesn't support SSL reloading", (Object)this.name));
            }
            this.updateHandlers.forEach(handler -> handler.accept(updatedBundle));
        }

        SslBundle getBundle() {
            return this.bundle;
        }

        void addUpdateHandler(Consumer<SslBundle> updateHandler) {
            Assert.notNull(updateHandler, "UpdateHandler must not be null");
            this.updateHandlers.add(updateHandler);
        }
    }
}

