/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.origin;

import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.util.ObjectUtils;

public class OriginTrackedValue
implements OriginProvider {
    private final Object value;
    private final Origin origin;

    private OriginTrackedValue(Object value, Origin origin) {
        this.value = value;
        this.origin = origin;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.value, ((OriginTrackedValue)obj).value);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.value);
    }

    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }

    public static OriginTrackedValue of(Object value) {
        return OriginTrackedValue.of(value, null);
    }

    public static OriginTrackedValue of(Object value, Origin origin) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)value;
            return new OriginTrackedCharSequence(charSequence, origin);
        }
        return new OriginTrackedValue(value, origin);
    }

    private static class OriginTrackedCharSequence
    extends OriginTrackedValue
    implements CharSequence {
        OriginTrackedCharSequence(CharSequence value, Origin origin) {
            super(value, origin);
        }

        @Override
        public int length() {
            return this.getValue().length();
        }

        @Override
        public char charAt(int index) {
            return this.getValue().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start2, int end) {
            return this.getValue().subSequence(start2, end);
        }

        @Override
        public CharSequence getValue() {
            return (CharSequence)super.getValue();
        }
    }
}

