/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.json.JsonWriter;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public record GraylogExtendedLogFormatProperties(String host, Service service) {
    static final GraylogExtendedLogFormatProperties NONE = new GraylogExtendedLogFormatProperties(null, Service.NONE);

    GraylogExtendedLogFormatProperties withDefaults(Environment environment2) {
        String name = GraylogExtendedLogFormatProperties.withFallbackProperty(environment2, this.host, "spring.application.name");
        Service service = this.service.withDefaults(environment2);
        return new GraylogExtendedLogFormatProperties(name, service);
    }

    static String withFallbackProperty(Environment environment2, String value, String property) {
        return !StringUtils.hasLength(value) ? environment2.getProperty(property) : value;
    }

    public void jsonMembers(JsonWriter.Members<?> members) {
        members.add("host", this::host).whenHasLength();
        this.service.jsonMembers(members);
    }

    public static GraylogExtendedLogFormatProperties get(Environment environment2) {
        return Binder.get(environment2).bind("logging.structured.gelf", GraylogExtendedLogFormatProperties.class).orElse(NONE).withDefaults(environment2);
    }

    public record Service(String version) {
        static final Service NONE = new Service(null);

        Service withDefaults(Environment environment2) {
            String version = GraylogExtendedLogFormatProperties.withFallbackProperty(environment2, this.version, "spring.application.version");
            return new Service(version);
        }

        void jsonMembers(JsonWriter.Members<?> members) {
            members.add("_service_version", this::version).whenHasLength();
        }
    }
}

