/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.json.JsonWriter;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public record ElasticCommonSchemaProperties(Service service) {
    static final ElasticCommonSchemaProperties NONE = new ElasticCommonSchemaProperties(Service.NONE);

    ElasticCommonSchemaProperties withDefaults(Environment environment2) {
        Service service = this.service.withDefaults(environment2);
        return new ElasticCommonSchemaProperties(service);
    }

    static String withFallbackProperty(Environment environment2, String value, String property) {
        return !StringUtils.hasLength(value) ? environment2.getProperty(property) : value;
    }

    public void jsonMembers(JsonWriter.Members<?> members) {
        this.service.jsonMembers(members);
    }

    public static ElasticCommonSchemaProperties get(Environment environment2) {
        return Binder.get(environment2).bind("logging.structured.ecs", ElasticCommonSchemaProperties.class).orElse(NONE).withDefaults(environment2);
    }

    public record Service(String name, String version, String environment, String nodeName) {
        static final Service NONE = new Service(null, null, null, null);

        void jsonMembers(JsonWriter.Members<?> members) {
            members.add("service.name", this::name).whenHasLength();
            members.add("service.version", this::version).whenHasLength();
            members.add("service.environment", this::environment).whenHasLength();
            members.add("service.node.name", this::nodeName).whenHasLength();
        }

        Service withDefaults(Environment environment2) {
            String name = ElasticCommonSchemaProperties.withFallbackProperty(environment2, this.name, "spring.application.name");
            String version = ElasticCommonSchemaProperties.withFallbackProperty(environment2, this.version, "spring.application.version");
            return new Service(name, version, this.environment, this.nodeName);
        }
    }
}

