/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import java.util.Objects;
import org.slf4j.event.KeyValuePair;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.logging.structured.ElasticCommonSchemaProperties;
import org.springframework.boot.logging.structured.JsonWriterStructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.core.env.Environment;

class ElasticCommonSchemaStructuredLogFormatter
extends JsonWriterStructuredLogFormatter<ILoggingEvent> {
    private static final JsonWriter.PairExtractor<KeyValuePair> keyValuePairExtractor = JsonWriter.PairExtractor.of(pair -> pair.key, pair -> pair.value);

    ElasticCommonSchemaStructuredLogFormatter(Environment environment2, ThrowableProxyConverter throwableProxyConverter, StructuredLoggingJsonMembersCustomizer<?> customizer2) {
        super(members -> ElasticCommonSchemaStructuredLogFormatter.jsonMembers(environment2, throwableProxyConverter, members), customizer2);
    }

    private static void jsonMembers(Environment environment2, ThrowableProxyConverter throwableProxyConverter, JsonWriter.Members<ILoggingEvent> members) {
        members.add("@timestamp", ILoggingEvent::getInstant);
        members.add("log.level", ILoggingEvent::getLevel);
        members.add("process.pid", environment2.getProperty("spring.application.pid", Long.class)).when(Objects::nonNull);
        members.add("process.thread.name", ILoggingEvent::getThreadName);
        ElasticCommonSchemaProperties.get(environment2).jsonMembers(members);
        members.add("log.logger", ILoggingEvent::getLoggerName);
        members.add("message", ILoggingEvent::getFormattedMessage);
        members.addMapEntries(ILoggingEvent::getMDCPropertyMap);
        members.from(ILoggingEvent::getKeyValuePairs).whenNotEmpty().usingExtractedPairs(Iterable::forEach, keyValuePairExtractor);
        members.add().whenNotNull(ILoggingEvent::getThrowableProxy).usingMembers(throwableMembers -> {
            throwableMembers.add("error.type", ILoggingEvent::getThrowableProxy).as(IThrowableProxy::getClassName);
            throwableMembers.add("error.message", ILoggingEvent::getThrowableProxy).as(IThrowableProxy::getMessage);
            throwableMembers.add("error.stack_trace", throwableProxyConverter::convert);
        });
        members.add("ecs.version", "8.11");
    }
}

