/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import java.io.IOException;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import org.springframework.boot.json.WritableJson;

final class StructuredMessage {
    private static final String JSON2 = "JSON";
    private static final String[] JSON = new String[]{"JSON"};

    private StructuredMessage() {
    }

    static Object get(Message message2) {
        MultiFormatStringBuilderFormattable multiFormatMessage;
        if (message2 instanceof MultiFormatStringBuilderFormattable && StructuredMessage.hasJsonFormat(multiFormatMessage = (MultiFormatStringBuilderFormattable)message2)) {
            return WritableJson.of(out -> StructuredMessage.formatTo(multiFormatMessage, out));
        }
        return message2.getFormattedMessage();
    }

    private static boolean hasJsonFormat(MultiFormatStringBuilderFormattable message2) {
        for (String format : message2.getFormats()) {
            if (!JSON2.equalsIgnoreCase(format)) continue;
            return true;
        }
        return false;
    }

    private static void formatTo(MultiFormatStringBuilderFormattable message2, Appendable out) throws IOException {
        if (out instanceof StringBuilder) {
            StringBuilder stringBuilder = (StringBuilder)out;
            message2.formatTo(JSON, stringBuilder);
        } else {
            out.append(message2.getFormattedMessage(JSON));
        }
    }
}

